DROP SEQUENCE seq_hd_activity_object_id;
DROP SEQUENCE seq_hd_role_object_id;
DROP SEQUENCE seq_hd_user_object_id;
DROP SEQUENCE seq_hd_autho_manager_object_id;
DROP TABLE hd_manager_activity;
DROP TABLE hd_activity_action;
DROP TABLE hd_activity_resource;
DROP TABLE hd_role_activity;
DROP TABLE hd_activity;
DROP TABLE hd_user_role;
DROP TABLE hd_manager_role;
DROP TABLE hd_role;
DROP TABLE hd_manager_user;
DROP TABLE hd_user;
DROP TABLE hd_authorization_manager;

CREATE TABLE hd_authorization_manager (
    object_id INTEGER PRIMARY KEY,
    name VARCHAR(256) NOT NULL
);

CREATE TABLE hd_user (
    object_id INTEGER PRIMARY KEY,
    user_id   VARCHAR(256),
    user_name VARCHAR(64),
    default_role VARCHAR(64),

    CONSTRAINT uq_hd_user_id UNIQUE (user_id)
);

CREATE TABLE hd_manager_user (
    manager_object_id INTEGER NOT NULL REFERENCES hd_authorization_manager(object_id),
    user_id VARCHAR(64),
    user_object_id INTEGER NOT NULL REFERENCES hd_user(object_id)
);

CREATE TABLE hd_role (
    object_id INTEGER PRIMARY KEY,
    role_name VARCHAR(64),
    short_desc VARCHAR(128),
    long_desc  VARCHAR(1024),

    CONSTRAINT uq_hd_role_name UNIQUE (role_name)
);

CREATE TABLE hd_user_role (
    user_object_id INTEGER NOT NULL REFERENCES hd_user(object_id),
    role_name VARCHAR(64),
    
    role_object_id INTEGER NOT NULL REFERENCES hd_role(object_id)
);

CREATE TABLE hd_manager_role (
    manager_object_id INTEGER NOT NULL REFERENCES hd_authorization_manager(object_id),
    role_name VARCHAR(64),
    role_object_id INTEGER NOT NULL REFERENCES hd_role(object_id)
);

CREATE TABLE hd_activity (
    object_id INTEGER PRIMARY KEY,
    activity_name VARCHAR(64),
    default_task VARCHAR(255),
    short_desc VARCHAR(128),
    long_desc  VARCHAR(1024),

    CONSTRAINT uq_hd_activity_name UNIQUE (activity_name)
);

CREATE TABLE hd_role_activity (
    role_object_id INTEGER NOT NULL REFERENCES hd_role(object_id),
    activity_name VARCHAR(64),
    activity_object_id INTEGER NOT NULL REFERENCES hd_activity(object_id)
);

CREATE TABLE hd_activity_resource (
    activity_object_id INTEGER NOT NULL REFERENCES hd_activity(object_id),
    key VARCHAR(255) NOT NULL,
    value VARCHAR(255) NOT NULL
);

CREATE TABLE hd_activity_action (
    activity_object_id INTEGER NOT NULL REFERENCES hd_activity(object_id),
    key VARCHAR(255) NOT NULL,
    value VARCHAR(255) NOT NULL
);

CREATE TABLE hd_manager_activity (
    manager_object_id INTEGER NOT NULL REFERENCES hd_authorization_manager(object_id),
    activity_name VARCHAR(64),
    activity_object_id INTEGER NOT NULL REFERENCES hd_activity(object_id)
);

CREATE SEQUENCE seq_hd_autho_manager_object_id START 100;
CREATE SEQUENCE seq_hd_user_object_id START 1000;
CREATE SEQUENCE seq_hd_role_object_id START 1000;
CREATE SEQUENCE seq_hd_activity_object_id START 1000;
