DROP SEQUENCE seq_hd_cache_value_id;
DROP SEQUENCE seq_hd_object_id;
DROP INDEX idx_monitored_attribute_monitor;
DROP INDEX idx_operating_system_name; 
DROP INDEX idx_group_device_group; 
DROP INDEX idx_operation_group_name; 
DROP INDEX idx_device_name; 
DROP TABLE hd_monitored_attribute;
DROP TABLE hd_cache_value;
DROP TABLE hd_operating_system_driver_param;
DROP TABLE hd_operating_system_attribute;
DROP TABLE hd_operating_system;
DROP TABLE hd_operation_group_attribute;
DROP TABLE hd_operation_group_device;
DROP TABLE hd_operation_group;
DROP TABLE hd_persistent_mbean;
DROP TABLE hd_driver_param;
DROP TABLE hd_attribute;
DROP TABLE hd_device;
DROP TABLE hd_schema_version;

CREATE TABLE hd_schema_version (
    version VARCHAR(32)
);

CREATE TABLE hd_device (
    object_id INTEGER PRIMARY KEY,
    name VARCHAR(512) NOT NULL,
    driver_url VARCHAR(256)
);

CREATE INDEX idx_device_name ON hd_device(name);

CREATE TABLE hd_attribute (
    device_object_id INTEGER NOT NULL REFERENCES hd_device(object_id),
    key VARCHAR(256) NOT NULL,
    value VARCHAR(2048) NOT NULL,
    CONSTRAINT uq_hd_attribute UNIQUE(device_object_id, key)
);

CREATE TABLE hd_driver_param (
    device_object_id INTEGER NOT NULL REFERENCES hd_device(object_id),
    key VARCHAR(256) NOT NULL,
    value BYTEA NOT NULL,
    CONSTRAINT uq_hd_driver_param UNIQUE(device_object_id, key)
);

CREATE TABLE hd_persistent_mbean (
    object_id INTEGER PRIMARY KEY,
    object_name VARCHAR (512) NOT NULL,
    class_name VARCHAR(512) NOT NULL,
    object_id_ INTEGER NOT NULL,
    time_stamp BIGINT NOT NULL,
    CONSTRAINT uq_hd_persistent_mbean UNIQUE(object_name)
);


CREATE TABLE hd_operation_group (
    object_id INTEGER PRIMARY KEY,
    name VARCHAR(256)
);

CREATE INDEX idx_operation_group_name ON hd_operation_group(name);

CREATE TABLE hd_operation_group_device (
    device_name VARCHAR(256),
    operation_group_id INTEGER NOT NULL 
        REFERENCES hd_operation_group(object_id)
);

CREATE INDEX idx_group_device_group ON hd_operation_group_device(operation_group_id);

CREATE TABLE hd_operation_group_attribute (
    group_object_id INTEGER NOT NULL REFERENCES hd_operation_group(object_id),
    key VARCHAR(256) NOT NULL,
    value VARCHAR(2048) NOT NULL,
    CONSTRAINT uq_hd_op_group_attribute UNIQUE(group_object_id, key)
);


CREATE TABLE hd_operating_system (
    object_id INTEGER PRIMARY KEY,
    name VARCHAR(256) NOT NULL,
    server_name VARCHAR(256),
    driver_url VARCHAR(256)
);

CREATE INDEX idx_operating_system_names ON hd_operating_system(name, server_name);

CREATE TABLE hd_operating_system_attribute (
    os_object_id INTEGER NOT NULL REFERENCES hd_operating_system(object_id),
    key VARCHAR(256) NOT NULL,
    value VARCHAR(2048) NOT NULL,
    CONSTRAINT uq_hd_os_attribute UNIQUE(os_object_id, key)
);

CREATE TABLE hd_operating_system_driver_param (
    os_object_id INTEGER NOT NULL REFERENCES hd_operating_system(object_id),
    key VARCHAR(256) NOT NULL,
    value BYTEA NOT NULL,
    CONSTRAINT uq_hd_os_driver_param UNIQUE(os_object_id, key)
);

CREATE TABLE hd_cache_value (
    object_id INTEGER PRIMARY KEY,
    object_name VARCHAR(512) NOT NULL,
    attribute VARCHAR(256),
    value BYTEA,
    time_stamp TIMESTAMP,
    throwable BYTEA
);

CREATE TABLE hd_monitored_attribute (
    object_id INTEGER PRIMARY KEY,
    monitor VARCHAR(512) NOT NULL,
    object_name VARCHAR(512) NOT NULL,
    attribute VARCHAR(256)
);

CREATE INDEX idx_monitored_attribute_monitor ON hd_monitored_attribute(monitor);

CREATE SEQUENCE seq_hd_object_id;
CREATE SEQUENCE seq_hd_cache_value_id;

INSERT INTO hd_schema_version VALUES ( '1.5' );
