#!/bin/sh
#
# Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#

#
# Helper script to run the DDL for N1 Grid Controller Jobs. NOTE
# that the N1GSPS postmaster ***MUST*** be running for
# this script to work. 
#

. /opt/sun/n1gc/bin/n1hss_common.sh

PSQL=$BASE/bin/psql
USER=roxadmin
PASS=roxOdin
DBNAME=rox
DDL=/opt/sun/n1gc/hd_domain_schema.sql
PORT=5433

LD_LIBRARY_PATH=$BASE/lib/
PGHOST=$BASE/socket
export LD_LIBRARY_PATH PGHOST

if [ `uname` = "SunOS" ]; then
/usr/bin/env PGPASSWORD=$PASS $PSQL -U $USER -p $PORT -f $DDL $DBNAME
else
/usr/bin/env PGPASSWORD=$PASS $PSQL -U $USER $DBNAME -p $PORT -f $DDL
fi

exit $?
