#!/bin/sh
#
# Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#

#
# Helper script to run the DDL for n1gc Jobs. NOTE
# that the N1GSPS postmaster ***MUST*** be running for
# this script to work. 
# This script runs log reaper sql. 
# The log reaper is responsible for deleting log records from DB
# based on an aging policy

. /opt/sun/n1gc/bin/n1hss_common.sh

#BASE=/opt/SUNWn1sps/N1_Grid_Service_Provisioning_System_5.1/server/postgres
PSQL=$BASE/bin/psql
USER=roxadmin
PASS=roxOdin
DBNAME=rox
DDL=/opt/sun/n1gc/hd_log_reaper.sql
PORT=5433
#ROX_HOME=/opt/SUNWn1sps/N1_Grid_Service_Provisioning_System_5.1

# define where to log messages for this script
LOG_DIR=/opt/sun/n1gc/etc/logs/
LOG_FILE=${LOG_DIR}/logreaper.log

LD_LIBRARY_PATH=$BASE/lib/
PGHOST=$BASE/socket
export LD_LIBRARY_PATH PGHOST

# check if DB is up before we try and delete any records
# code to check DB was lifted from GSPS roxchk script
if [ "(" -f $ROX_HOME/server/postgres/data/postmaster.pid ")" -o "(" -f $ROX_HOME/postgres/data/postgres.pid ")" ]; then
    # DB is running 
    # capture output from psql command to see if we deleted any records
   if [ `uname` = "SunOS" ]; then
       PSQL_OUT=`/usr/bin/env PGPASSWORD=$PASS $PSQL -U $USER -p $PORT -f $DDL $DBNAME`
    else
       PSQL_OUT=`/usr/bin/env PGPASSWORD=$PASS $PSQL -U $USER $DBNAME -p $PORT -f $DDL`
   fi

else
    # don't try and delete any records since DB is down, just exit
    exit
fi

# Expect PSQL_OUT to look something like "DELETE N" where N is a number
# grab number deleted from output
NUM_DELETED=`echo $PSQL_OUT | awk '{print $2}'`

# Only log a message if we actually deleted something
if [ ${NUM_DELETED} -gt 0 ]
then
	echo `date` " Log Reaper deleted " ${NUM_DELETED} " records" >> ${LOG_FILE}
fi

exit 0
