#! /bin/sh
#
# Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#

if [ `uname` = "SunOS" ]; then

# Core XPack installed?
pkginfo  SUNWn1hss-core >/dev/null 2>&1
if [ $? -eq 0 ]
then
    INSTALLED_XPACKS=Core-1.0
fi

# Drvr XPack installed?
pkginfo SUNWn1hss-drvrs >/dev/null 2>&1
if [ $? -eq 0 ]
then
    DRVR=Drivers-1.0
    INSTALLED_XPACKS=`echo ${INSTALLED_XPACKS},${DRVR}`
fi

# App Provisioning XPack installed?
pkginfo SUNWn1hss-appln >/dev/null 2>&1
if [ $? -eq 0 ]
then
    APPLN="Application Deployment-1.0"
    INSTALLED_XPACKS=`echo ${INSTALLED_XPACKS},${APPLN}`
fi

# GE XPack installed?
pkginfo SUNWn1hss-ge >/dev/null 2>&1
if [ $? -eq 0 ]
then
    GE="n1ge-1.0"
    INSTALLED_XPACKS=`echo ${INSTALLED_XPACKS},${GE}`
fi

# Display result to stdout
echo $INSTALLED_XPACKS
exit 0

fi

if [ `uname` = "Linux" ]; then

# Core XPack installed?
rpm -q sun-n1hss-core >/dev/null 2>&1
if [ $? -eq 0 ]
then
    INSTALLED_XPACKS=Core-1.0
fi

# Drvr XPack installed?
rpm -q sun-n1hss-drvrs >/dev/null 2>&1
if [ $? -eq 0 ]
then
    DRVR=Drivers-1.0
    INSTALLED_XPACKS=`echo ${INSTALLED_XPACKS},${DRVR}`
fi

# App Provisioning XPack installed?
rpm -q sun-n1hss-appln >/dev/null 2>&1
if [ $? -eq 0 ]
then
    APPLN="Application Deployment-1.0"
    INSTALLED_XPACKS=`echo ${INSTALLED_XPACKS},${APPLN}`
fi

# GE XPack installed?
rpm -q sun-n1hss-ge >/dev/null 2>&1
if [ $? -eq 0 ]
then
   GE="n1ge-1.0"

    INSTALLED_XPACKS=`echo ${INSTALLED_XPACKS},${GE}`
fi


# Display result to stdout
echo $INSTALLED_XPACKS
exit 0

fi
