#!/usr/bin/env python

from __future__ import generators

import sys, os, string
from Getline import Getline
import n1common

from xml.sax import handler
import types



#
# N1 Tab completion
class n1line(Getline):

    def __init__(self, prompt=''):
        Getline.__init__(self, prompt)

        self.whitespace = self.whitespace + '='  # Treat '=' like whitespace
        self.tabdata = None

    class TabdataError(Exception):
        """The tabdata is an incorrect format."""
        pass


    # Alias to local function.
    def split_commandline(self, line):
        return n1common.tokenize(line)

    def set_tabdata(self, tabdata):
        if not isinstance(tabdata, TokenNode):
            raise self.TabdataError
        #print_commands(tabdata)
        self.tabdata = tabdata


    def do_tab(self):
        if not self.line and self.prev_char != '\t':
            self.beep()
            return

        tok = []
        loc = self.cursor
        while loc:
            loc -= 1
            if self.line[loc] in self.whitespace:
                break
            tok.append(self.line[loc])

        tok.reverse()
        text = ''.join(tok)
        matches = self.completion_matches(text, self.line, self.cursor)

        if not matches:
            self.beep()
        elif type(matches) in types.StringTypes:
            for self._char in matches[len(text):] + ' ':
                self.do_print()
        elif type(matches) == types.ListType:
            print
            self.possible_completions(matches)
            self.print_prompt()

            # Fill in the most matching characters
            matching_chars = []
            names = [ n.name for n in matches ]
            if not len(names) == 1:
                for i in range(len(text), len(names[0])):
                    c = (names[0])[i]
                    match_all = True
                    for n in names[1:]:
                        if n[i] != c:
                            match_all = False
                            break
                    if match_all:
                        matching_chars.append(c)
                    else:
                        break

                for self._char in matching_chars:
                    self.do_print()
        else:
            raise Exception

    def is_userval(self, s):
        return n1common.is_userval(s)

    def get_userval_node(self, next):
        return n1common.get_userval_node(next)

    def completion_matches(self, text, line, start):
        """
        Return either a list of possible matches, which gets printed
        by possible_completions(); or the string that will be completed.
        """

        commands = self.split_commandline(line[:start])

        if text:
            # Handle any partial text later...
            commands.pop()

        descriptors = self.map_commands_to_nodes(self.tabdata, commands)
        if descriptors == None:
            return []

        nodes = self.find_next_nodes(descriptors)

        matches = filter(lambda n: n.name.startswith(text), nodes)

        if len(matches) == 1 and not self.is_userval(matches[0].name):
            return matches[0].name

        return matches


    def possible_completions(self, matches):
        return n1common.possible_completions(matches,
            self.line[:self.cursor], self.output)


    def map_commands_to_nodes(self, node, commands):
        return n1common.map_commands_to_nodes(node, commands)


    def find_next_nodes(self, desc_nodes):
        """Return a list of the next tokens as nodes."""

        if not desc_nodes:
            return self.tabdata.tokens.values() + self.tabdata.attrs.values()

        desc = None
        while desc_nodes:
            if isinstance(desc_nodes[0], AttributeDesc):
                break
            desc = desc_nodes.pop(0)

        if not desc_nodes:
            # Reached the end, just return the nodes...
            return desc.node.tokens.values() + desc.node.attrs.values()

        attrs = desc.node.attrs
        found_attrs = []
        while desc_nodes:
            desc = desc_nodes.pop(0)
            try:
                nextnode = attrs[desc.token]
                found_attrs.append(nextnode.name)
                desc_nodes.pop(0)
            except KeyError:
                return []
            except IndexError:
                return nextnode.tokens.values()

        return [ n for n in attrs.values() if n.name not in found_attrs ]

#
# Token descriptors.
class TokenDesc:
    """Hold command token and its associated node."""

    def __init__(self, token = '', node = None):
        self.token = token
        self.node = node

    def __repr__(self):
        return '[ Token: %s; Node.name: %s]' % (self.token, self.node.name)

class ArgumentDesc(TokenDesc):
    """Hold command argument and its associated node."""

class AttributeDesc(TokenDesc):
    """Hold command attribute and its associated node."""

class AttrNameDesc(AttributeDesc):
    """Hold command attribute name and its associated node."""

class AttrValueDesc(AttributeDesc):
    """Hold command attribute value and its associated node."""




#
# Tab completion data structure and parser

class TokenNode:
    """Information about a specific step in the command hierarchy."""

    def __init__(self, name = ''):
        self.name = name
        #self.parent = ''
        self.tokens = {}
        self.attrs = {}
        self.help = ''
        self.sensitive = False

    def __cmp__(self, other):
        return cmp(self.name, other.name)

class AttributeNode(TokenNode):
    """Information about attributes."""

    def __init__(self, name = ''):
        TokenNode.__init__(self, name)


# xml tab data SAX parser
class CommandHandler(handler.ContentHandler):
    """Parse command tab data XML."""

    def __init__(self, tree = TokenNode()):
        self.tree = tree
        self.nodes = []

    def get_command_tree(self):
        """Return the collected data structure."""

        return self.tree

    def find_leaf_attrs(self, node):
        """Generator for leaf attribute nodes."""

        for n in node.values():
            if n.tokens:
                for nn in self.find_leaf_attrs(n.tokens):
                    yield nn
            else:
                yield n

    def startElement(self, name, attrs):
        if name == 'tree':
            self.nodes = [ self.tree ]
        elif name == 'node':
            s = attrs.getValue('s')

            # If the node doesn't exist, create a new one.
            try: me = self.nodes[len(self.nodes)-1].tokens[s]
            except KeyError: me = TokenNode(s)

            try: me.help = attrs.getValue('md:help')
            except KeyError: pass
            try: me.sensitive = (attrs.getValue('md:sensitive').lower() == 'true')
            except KeyError: pass

            self.nodes.append(me)
        elif name == 'set':
            me = TokenNode('/set/')
            self.nodes.append(me)

    def endElement(self, name):
        if name == 'tree':
            pass
        elif name == 'node':
            n = self.nodes.pop()
            last = self.nodes.pop()
            last.tokens[n.name] = n
            #n.parent = last
            self.nodes.append(last)
        elif name == 'set':
            s = self.nodes.pop()
            last = self.nodes.pop()
            last.attrs = s.tokens

            # Link the leaf-nodes in attrs back to attrs for easier
            # mapping of commands to nodes.
            for n in self.find_leaf_attrs(s.tokens):
                n.attrs = last.attrs

            #for k in last.attrs:
            #    last.attrs[k].parent = last
            self.nodes.append(last)


#
# Helpers...
#
def print_commands(node, lvl = 0, ignore_attrs = False):
    """Prints out the command map for debugging."""

    def print_node(indent, n, prefix = ''):
        print indent + prefix + n.name + '\t' + n.help

    indent = "   " * lvl
    lvl += 1

    all = node.tokens.keys()
    all.sort()
    for key in all:
        n = node.tokens[key]
        print_node(indent, n)
        print_commands(n, lvl, ignore_attrs)

    if not ignore_attrs:
        set = node.attrs.keys()
        set.sort()
        for key in set:
            n = node.attrs[key]
            print_node(indent, n, '*')
            print_commands(n, lvl, True)




