#!/bin/sh
#
# Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#

# use ed for editor
#EDITOR=/bin/ed
#export EDITOR
TEMPFILE=/tmp/cron.$$
TARGET_OS=`uname`

# create a crontab entry that runs every Sunday and deletes old logs

# save existing crontab, without the header, to be add back to crontab later
#savedcron=`crontab -l |tail +4` 
crontab -l |grep hd_logreaper.sh >/dev/null 2>&1
if [ $? -ne 0 ]
then
crontab -l >$TEMPFILE
if [ $TARGET_OS = "Linux" ]
then

cat << !EOF >> "$TEMPFILE"
#
# logreaper Use sh to execute commands
SHELL=/bin/sh
#
# logreaper Don't send mail after running this entry.
MAILTO=""
#
# logreaper Run log reaper script every sunday at midnight
0 0 * * 0 /opt/sun/n1gc/bin/hd_logreaper.sh >> /opt/sun/n1gc/etc/logs/logreaper.log
!EOF

else

# Solaris doesn't like MAILTO and SHELL

cat << !EOF >> "$TEMPFILE"
#
# logreaper Run log reaper script every sunday at midnight
0 0 * * 0 /opt/sun/n1gc/bin/hd_logreaper.sh >> /opt/sun/n1gc/etc/logs/logreaper.log
!EOF
fi

crontab $TEMPFILE
rm $TEMPFILE
fi
