-- ----------------------------------------------------------------
--
--	Copyright (c) Raplix, Inc. 2000-2001. All Rights Reserved.
--
-- Raplix RolloutExpress schema drop script
--
-- Created on May 31, 2001
--
-- ----------------------------------------------------------------

--
-- version table describes version of schema
--
DROP TABLE ROX_VERSION;

-- old table should also get dropped for cleanup
DROP TABLE T_VERSION;


-- BEGIN RSRC SCHEMA --

-- SQL Table Generation from Classmap for Class: com.raplix.rolloutexpress.resource.RsrcInfoImpl
DROP TABLE RSRC_INFO;
DROP TABLE ROX_SYSTEM_DATA;
DROP TABLE ROX_RSRC_INFO;
DROP TABLE ROX_RSRC_PUSHES;
DROP TABLE ROX_RESOURCE;
DROP TABLE ROX_RESOURCE_TO_CAT_LINK;

-- END RSRC SCHEMA --

-- BEGIN DIFF SCHEMA --

-- SQL Table Generation from Classmap for Class: com.raplix.rolloutexpress.difference.differencedb.DifferenceSettings

-- DROP the old difference settings table in case people still have that (should go away)
DROP TABLE DIFFERENCE_SETTINGS;
DROP TABLE ROX_DIFFSET_TO_COMP_NAME_REF;
DROP TABLE ROX_DIFFSET_TO_CAT_LINK;
DROP TABLE ROX_DIFFERENCE_SETTINGS;
DROP TABLE ROX_DIFFERENCE;
DROP TABLE ROX_DIFFERENCE_JOB;
-- END DIFF SCHEMA --

-- BEGIN INSTALL DB SCHEMA --
DROP INDEX I_ROX_SNAPSHOT_INSTCOMPID;
DROP TABLE ROX_SNAPSHOT_TO_HOST_LINK;
DROP TABLE ROX_SNAPSHOT;
DROP TABLE ROX_DEPENDENCY_TO_COMP_NAME_REF;
DROP TABLE ROX_DEPENDENCY;
DROP TABLE ROX_INSTALLED_RESOURCE;
DROP TABLE ROX_INST_COMP_TO_INST_COMP_LINK;
DROP TABLE ROX_INSTALLED_COMPONENT;

-- END INSTALL DB SCHEMA --

-- BEGIN COMPONENTDB SCHEMA --

DROP TABLE ROX_COMPTYPE_TO_COMP_LINK;
DROP TABLE ROX_COMPTYPE_TO_COMPTYPE_LINK;
DROP TABLE ROX_SYSTEM_SERVICE_REF;
DROP TABLE ROX_COMPONENT_TYPE_REF;
DROP TABLE ROX_COMPVARSET_TO_COMP_NAME_REF;
DROP TABLE ROX_COMP_VAR_SETTINGS;
DROP TABLE ROX_COMPONENT_TO_COMP_LINK;
DROP TABLE ROX_COMPONENT_TO_COMP_NAME_REF;
DROP TABLE ROX_COMPONENT_TO_RSRC_LINK;
DROP TABLE ROX_COMPONENT_TO_CAT_LINK;
DROP TABLE ROX_COMPONENT;
DROP TABLE ROX_CONTROL;
DROP TABLE ROX_COMPONENT_DEFINITION;
DROP TABLE ROX_RESOURCE_DEFINITION;

-- END COMPONENTDB SCHEMA --

-- BEGIN PLANDB SCHEMA --

-- Thse two drop statements are here because some databases will have these
-- original (longer) table names. These can be removed after the Fiji release.
DROP TABLE ROX_EXECUTION_PLAN_TO_PLAN_NAME_REF;
DROP TABLE ROX_EXECUTION_PLAN_TO_COMP_NAME_REF;

DROP TABLE ROX_PLAN_TO_PLAN_NAME_REF;
DROP TABLE ROX_PLAN_TO_COMP_NAME_REF;
DROP TABLE ROX_PLAN_TO_CAT_LINK;
DROP TABLE ROX_EXECUTION_PLAN;

-- END PLANDB SCHEMA --

-- BEGIN CONFIGGEN SCHEMA

DROP TABLE ROX_GEN_VAR_SETTINGS;

-- END CONFIGGEN SCHEMA

-- BEGIN EVENT SCHEMA --

-- SQL Table Generation from Classmap for Class: com.raplix.rolloutexpress.event.ROXEventFactory

DROP INDEX I_ROX_EVENTS_EVENTTYPE;
DROP TABLE ROX_EVENTS;

-- END EVENT SCHEMA --

-- BEGIN USERDB SCHEMA --

DROP TABLE ROX_SESSION_VAR;

DROP TABLE ROX_SESSION_VAR_SET;

DROP TABLE ROX_SESSION_VAR_DESC;

-- SQL Table Generation from Classmap for Class: com.raplix.rolloutexpress.systemmodel.userdb.PersistentGroupMember

DROP TABLE ROX_GROUP_MEMBER;

-- SQL Table Generation from Classmap for Class: com.raplix.rolloutexpress.systemmodel.userdb.PersistentGroupGraph

DROP TABLE ROX_GROUP_GRAPH;

-- SQL Table Generation from Classmap for Class: com.raplix.rolloutexpress.systemmodel.userdb.PersistentParentChildGroup

DROP TABLE ROX_PARENT_CHILD_GROUP;

-- SQL Table Generation from Classmap for Class: com.raplix.rolloutexpress.systemmodel.userdb.PersistentGrantedPermission

DROP TABLE ROX_GRANTED_PERMISSION;


DROP FUNCTION rox_group_relations_count(varchar, varchar);

-- SQL Table Generation from Classmap for Class: com.raplix.rolloutexpress.systemmodel.userdb.PersistentPermissionData

DROP TABLE ROX_PERMISSION;

-- SQL Table Generation from Classmap for Class: com.raplix.rolloutexpress.systemmodel.userdb.PersistentUserData

DROP TABLE ROX_USER;

-- SQL Table Generation from Classmap for Class: com.raplix.rolloutexpress.systemmodel.userdb.PersistentGroupData

DROP TABLE ROX_GROUP;

-- drop old table names as well for cleanup
DROP TABLE T_GROUP_MEMBER;
DROP TABLE T_GROUP_GRAPH;
DROP TABLE T_PARENT_CHILD_GROUP;
DROP TABLE T_GRANTED_PERMISSION;
DROP FUNCTION t_group_relations_count(varchar, varchar);
DROP TABLE T_PERMISSION;
DROP TABLE T_USER;
DROP TABLE T_GROUP;

-- END USERDB SCHEMA --

-- BEGIN RULES SCHEMA --
DROP TABLE ROX_RULE;
DROP TABLE ROX_ACTION;
DROP TABLE ROX_CRITERIA_TO_HOST_LINK;
DROP TABLE ROX_CRITERIA;
-- END RULES SCHEMA --

-- BEGIN HOSTDB PLAN LOCK SCHEMA --
-- This drop statement is here because some databases will have this
-- table. It can be removed after the Fiji release.
DROP TABLE ROX_HOST_PLAN_LOCK;
-- END HOSTDB PLAN LOCK SCHEMA --

-- BEGIN STEP_INFO SCHEMA --
DROP TABLE ROX_STEP_INFO;
DROP FUNCTION rox_step_info_after_insert ();
-- END STEP_INFO SCHEMA --

-- BEGIN STEPINFO_COUNTER SCHEMA --
DROP TABLE ROX_STEPINFO_COUNTER;
-- END STEPINFO_COUNTER SCHEMA --

-- BEGIN TASK_INFO SCHEMA --
DROP TABLE ROX_EXEC_NATIVE_INFO;
DROP TABLE ROX_TASK_INFO;
-- END TASK_INFO SCHEMA --

-- BEGIN SUBPLAN_PROMPT SCHEMA --
-- MTS This is kept around to drop old
-- schema tables
DROP TABLE ROX_SUBPLAN_PROMPT;
-- END SUBPLAN_PROMPT SCHEMA --

-- BEGIN SUBPLAN_INFO SCHEMA --
DROP TABLE ROX_SUBPLAN_TO_TARGET_LINK;
DROP TABLE ROX_SUBPLAN_INFO;
-- END SUBPLAN_INFO SCHEMA --

-- BEGIN TARGET SCHEMA --
DROP INDEX I_ROX_TARGET_LOGICAL;
DROP TABLE ROX_TARGET;
-- END TARGET SCHEMA --

DROP TABLE ROX_HOST_STATUS;
-- END HOST_STATUS SCHEMA --
DROP TABLE ROX_TARGET_STATUS;
-- END TARGET_STATUS SCHEMA --

-- BEGIN HOSTDB SCHEMA --

-- following safe to remove post suva
DROP FUNCTION rox_hostset_graph_path_count(varchar, varchar); 

-- following safe to remove post suva
DROP TABLE ROX_HOST_SET_GRAPH_LINK;

DROP TABLE ROX_HOST_SET_TO_HOST_SET_LINK;
DROP TABLE ROX_HOST_SET_TO_HOST_SEARCH_LINK;
DROP TABLE ROX_HOST_SET_TO_SEARCH_LINK;
DROP TABLE ROX_VAR_CRITERIA;
DROP TABLE ROX_OS_NAME_CRITERIA;
DROP TABLE ROX_OS_VERSION_CRITERIA;
DROP TABLE ROX_OS_ARCH_CRITERIA;
DROP TABLE ROX_PARENT_CRITERIA;
DROP TABLE ROX_IP_ADDRESS_CRITERIA;
DROP TABLE ROX_HOST_TYPE_CRITERIA;
DROP TABLE ROX_DESCRIPTION_CRITERIA;
DROP TABLE ROX_NAME_CRITERIA;
DROP TABLE ROX_HOST_SEARCH;

DROP TABLE ROX_HOST_SET_TO_HOST_LINK;
DROP TABLE ROX_HOST_SET;

DROP TABLE ROX_APP_INSTANCE;
DROP TABLE ROX_HOST_VAR_OVERRIDE;
DROP TABLE ROX_HOST;

DROP TABLE ROX_HOST_TYPE_VAR_DECL;
DROP TABLE ROX_HOST_TYPE;

DROP TABLE ROX_AUTOGENERATED_PLAN;

-- END HOSTDB SCHEMA --

-- BEGIN FOLDERDB SCHEMA --
DROP TABLE ROX_FOLDER_TO_FOLDER_LINK;
DROP TABLE ROX_FOLDER;
-- END FOLDERDB SCHEMA --

-- BEGIN CATDB SCHEMA --

DROP TABLE ROX_CATEGORY;
-- END CATDB SCHEMA --


-- BEGIN PLUGINDB SCHEMA --

DROP TABLE ROX_PLUGIN_DEPENDENCY_LINK;

DROP TABLE ROX_PLUGIN;

-- END PLUGINDB SCHEMA --

DROP FUNCTION fail_mandatory_step(varchar);
DROP FUNCTION count_failed_hosts(varchar, varchar, integer, varchar);
DROP FUNCTION rox_events_after_insert ();

-- BEGIN SQL PARSER TEST --

-- should be able to have semis; and quotes ' with comments
-- without any problems

-- the following will cause an error as the version table doesn't exist
-- we don't care since errors in the drop schema are ignored

DELETE FROM ROX_VERSION
  WHERE C_VERSION = 'should be able to have semis;
                     and comments -- within quote'
    AND C_TYPE IS NULL;

-- END SQL PARSER TEST --
