-- see rox_create_schema for data constants

-- sentinel deleted host
INSERT INTO ROX_HOST (OBJECTID, C_NAME, C_DESCRIPTION, C_HOST_TYPE_ID, C_VISIBILITY)
  VALUES('010010001024-0000000000000-00005-0000000005',
	 '(deleted host)','this host has been deleted',
         (select OBJECTID from ROX_HOST_TYPE where c_name='system#crhost'), 0);

-- master server host
INSERT INTO ROX_HOST (OBJECTID, C_NAME, C_DESCRIPTION, C_HOST_TYPE_ID)
  VALUES('010010001024-0000000000000-00001-0000000005',
	 'masterserver','the master server host',
         (select OBJECTID from ROX_HOST_TYPE where c_name='system#crhost'));

-- MS app instance for master server host
INSERT INTO ROX_APP_INSTANCE (OBJECTID, C_TYPE, C_PORT, C_IP_ADDRESS,
			      C_IP_ADDRESS_STRING, C_HOST_ID)
  VALUES('010010001024-0000000000000-00001-0000000006',
	 0,8090,2130706433,'127.0.0.1',
	 '010010001024-0000000000000-00001-0000000005');


-- sentinel deleted component
INSERT INTO ROX_COMPONENT 
  (OBJECTID, C_UPDATE_COUNT, 
   ROOT_ID, VERSION, 
   C_NAME, C_DESCRIPTION, 
   C_IGNORE_PATHS, C_SOFTWARE_VENDOR, C_AUTHOR, 
   C_XML_CONTENT, 
   C_MODIFIER, C_VISIBILITY, C_PATHID,
   C_PLUGIN_ID)
  VALUES('010010001024-0000000000000-00022-0000000052',1,
         '010010001024-0000000000000-00022-0000000052', 65536,
         '(deleted component)','this component has been deleted', 
         '{}', 'Sun Microsystems', 'system',
         '<component xmlns="http://www.sun.com/schema/SPS" version="5.0"/>', 
         1, 0, 
         (select OBJECTID from ROX_FOLDER where c_full_path='/system/'),
         (select OBJECTID from ROX_PLUGIN p where p.c_name='system'));

INSERT INTO ROX_COMPONENT_TO_COMP_NAME_REF
    (C_PARENT_ID, C_CHILD_NAME, C_CHILD_PATH)
    VALUES('010010001024-0000000000000-00022-0000000052', '(deleted component)', '/system/' );

-- sentinel deleted plan
INSERT INTO ROX_EXECUTION_PLAN 
( C_DESCRIPTION,VERSION,
  USER_ID,
  C_PATHID,
  C_NAME,
  ROOT_ID,
  C_STEPS,
  C_UPDATE_COUNT,OBJECTID,
  c_PLUGIN_ID )
VALUES  ( 'this plan has been deleted',65536,
          '010010001019-0000000000000-00001-0000000001',
         (select OBJECTID from ROX_FOLDER where c_full_path='/system/'),
          '(deleted plan)',
          '010010001019-0000000000000-00009-0000000001',
	  '<?xml version="1.0" encoding="UTF-8"?><executionPlan xmlns="http://www.sun.com/schema/SPS" version="5.0">
		  <simpleSteps><pause delaySecs="1"/></simpleSteps></executionPlan>',
	  1,'010010001019-0000000000000-00009-0000000001',
         (select OBJECTID from ROX_PLUGIN p where p.c_name='system'));

-- hard-coded plan for prepping hosts
INSERT INTO ROX_EXECUTION_PLAN 
( C_DESCRIPTION,VERSION,C_VISIBILITY,
  USER_ID,
  C_PATHID,
  C_NAME,ROOT_ID,
  C_STEPS,
  C_UPDATE_COUNT,OBJECTID,
  C_PLUGIN_ID )
VALUES  ( '',65536,0,
          '010010001024-0000000000000-00001-0000000001',
          (select OBJECTID from ROX_FOLDER where c_full_path='/system/'),
          'prepHostsPlan','010010001013-0000000000000-00001-0000000009',
          '<?xml version="1.0" encoding="UTF-8"?><executionPlan xmlns="http://www.sun.com/schema/SPS" version="5.0">
		  <simpleSteps><deploySystemServices/></simpleSteps></executionPlan>',
          1,'010010001013-0000000000000-00001-0000000009',
         (select OBJECTID from ROX_PLUGIN p where p.c_name='system'));

INSERT INTO ROX_PLAN_TO_PLAN_NAME_REF
    (C_PARENT_ID, C_CHILD_NAME, C_CHILD_PATH)
    VALUES ('010010001019-0000000000000-00009-0000000001',
    '(deleted plan)', '/system/');

INSERT INTO ROX_PLAN_TO_PLAN_NAME_REF
    (C_PARENT_ID, C_CHILD_NAME, C_CHILD_PATH)
    VALUES ('010010001013-0000000000000-00001-0000000009',
    'prepHostsPlan', '/system/');

-- sentinel deleted task info 
INSERT INTO ROX_TASK_INFO (OBJECTID, C_PLAN_ID, C_RUN_LEVEL, C_PLAN_TIMEOUT, C_NATIVE_CALL_TIMEOUT, C_ROX_USER)
  VALUES('010010001019-0000000000000-00011-0000000001', '010010001019-0000000000000-00009-0000000001',
         'ACTUAL', 0, 0, '010010001019-0000000000000-00001-0000000001');

-- target for master server
INSERT INTO ROX_TARGET (OBJECTID, C_LOGICAL_HOST_ID, C_ACTUAL_HOST_ID, C_PHYSICAL_HOST_ID)
  VALUES('010010001019-0000000000000-00012-0000000001', 
         '010010001024-0000000000000-00005-0000000005',
         '010010001024-0000000000000-00005-0000000005', 
         '010010001024-0000000000000-00005-0000000005');

-- execute permission on autogen folder
INSERT INTO ROX_PERMISSION (OBJECTID, C_CLASS_NAME, C_NAME, C_ACTIONS)
 VALUES('010010001024-0000000000000-00034-0000000003',
        'com.raplix.rolloutexpress.systemmodel.userdb.FolderPermission',
        'folder:' || 
        (select OBJECTID from rox_folder where c_full_path='/system/autogen/')
        || ':hostset:*', 'execute');

-- grant execute permission above to registered group
INSERT INTO ROX_GRANTED_PERMISSION (C_GROUP_ID, C_PERMISSION_ID)
 VALUES('010010001024-0000000000000-00002-0000000002',
        '010010001024-0000000000000-00034-0000000003'); 
