/*
 * Decompiled with CFR 0.152.
 */
package com.sun.n1.util.enum;

import com.sun.n1.util.enum.Enum;
import com.sun.n1.util.enum.EnumFactory;
import com.sun.n1.util.enum.EnumImpl;
import com.sun.n1.util.enum.NoSuchEnumException;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class EnumFactoryImpl
implements EnumFactory {
    private ArrayList mEnumList;
    private HashMap mEnumMap;

    protected EnumFactoryImpl() {
        this.mEnumList = new ArrayList();
        this.mEnumMap = new HashMap();
    }

    protected EnumFactoryImpl(int expectedSize) {
        this.mEnumList = new ArrayList(expectedSize);
        this.mEnumMap = new HashMap(expectedSize);
    }

    int register(EnumImpl enumImpl) {
        String key = enumImpl.toString();
        EnumImpl oldValue = this.mEnumMap.put(key, enumImpl);
        if (oldValue != null) {
            this.mEnumMap.put(key, oldValue);
            throw new IllegalArgumentException("enum exists: " + key);
        }
        int size = this.mEnumList.size();
        this.mEnumList.add(enumImpl);
        return size;
    }

    public Enum getEnum(String value) throws NoSuchEnumException {
        Enum result = (Enum)this.mEnumMap.get(value);
        if (result == null) {
            throw new NoSuchEnumException(value);
        }
        return result;
    }

    public Enum getEnum(int value) throws NoSuchEnumException {
        if (value < 0 || value >= this.mEnumList.size()) {
            throw new NoSuchEnumException(value);
        }
        return (Enum)this.mEnumList.get(value);
    }

    public Enum[] getAllEnums(Enum[] container) {
        return this.mEnumList.toArray(container);
    }
}

