/*
 * Decompiled with CFR 0.152.
 */
package com.sun.n1.sps.userdb;

import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class LdapLoginModule
implements LoginModule {
    private static final String USERNAME_KEY = "javax.security.auth.login.name";
    private static final String PASSWORD_KEY = "javax.security.auth.login.password";
    private static final String USER_PROVIDER = "userProvider";
    private static final String USER_FILTER = "userFilter";
    private static final String USER_IDENTITY = "authIdentity";
    private static final String USERNAME_TOKEN = "{USERNAME}";
    private static final Pattern USERNAME_PATTERN = Pattern.compile("\\{USERNAME\\}");
    private String userProvider;
    private String userFilter;
    private String authIdentity;
    private boolean useSSL = true;
    private boolean authFirst = false;
    private boolean authOnly = false;
    private boolean useFirstPass = false;
    private boolean tryFirstPass = false;
    private boolean storePass = false;
    private boolean clearPass = false;
    private boolean debug = false;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username;
    private char[] password;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private LdapContext ctx;
    private Matcher identityMatcher = null;
    private Matcher filterMatcher = null;
    private Hashtable ldapEnvironment;
    private SearchControls constraints = null;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.ldapEnvironment = new Hashtable(7);
        this.ldapEnvironment.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        this.userProvider = (String)options.get(USER_PROVIDER);
        if (this.userProvider != null) {
            this.ldapEnvironment.put("java.naming.provider.url", this.userProvider);
        }
        this.authIdentity = (String)options.get(USER_IDENTITY);
        if (this.authIdentity != null && this.authIdentity.indexOf(USERNAME_TOKEN) != -1) {
            this.identityMatcher = USERNAME_PATTERN.matcher(this.authIdentity);
        }
        this.userFilter = (String)options.get(USER_FILTER);
        if (this.userFilter != null) {
            if (this.userFilter.indexOf(USERNAME_TOKEN) != -1) {
                this.filterMatcher = USERNAME_PATTERN.matcher(this.userFilter);
            }
            this.constraints = new SearchControls();
            this.constraints.setSearchScope(2);
            this.constraints.setReturningAttributes(new String[0]);
            this.constraints.setReturningObjFlag(true);
        }
        if (this.authIdentity != null) {
            if (this.userFilter != null) {
                this.authFirst = true;
            } else {
                this.authOnly = true;
            }
        }
        if ("false".equalsIgnoreCase((String)options.get("useSSL"))) {
            this.useSSL = false;
        } else {
            this.ldapEnvironment.put("java.naming.security.protocol", "ssl");
        }
        this.tryFirstPass = "true".equalsIgnoreCase((String)options.get("tryFirstPass"));
        this.useFirstPass = "true".equalsIgnoreCase((String)options.get("useFirstPass"));
        this.storePass = "true".equalsIgnoreCase((String)options.get("storePass"));
        this.clearPass = "true".equalsIgnoreCase((String)options.get("clearPass"));
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
        if (this.debug) {
            if (this.authFirst) {
                System.out.println("\t\t[LdapLoginModule] authentication-first mode; " + (this.useSSL ? "SSL enabled" : "SSL disabled"));
            } else if (this.authOnly) {
                System.out.println("\t\t[LdapLoginModule] authentication-only mode; " + (this.useSSL ? "SSL enabled" : "SSL disabled"));
            } else {
                System.out.println("\t\t[LdapLoginModule] search-first mode; " + (this.useSSL ? "SSL enabled" : "SSL disabled"));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean login() throws LoginException {
        if (this.userProvider == null) {
            throw new LoginException("Unable to locate the LDAP directory service");
        }
        if (this.debug) {
            System.out.println("\t\t[LdapLoginModule] user provider: " + this.userProvider);
        }
        if (this.tryFirstPass) {
            try {
                this.attemptAuthentication(true);
                this.succeeded = true;
                if (this.debug) {
                    System.out.println("\t\t[LdapLoginModule] tryFirstPass succeeded");
                }
                return true;
            }
            catch (LoginException le) {
                this.cleanState();
                if (!this.debug) ** GOTO lbl29
                System.out.println("\t\t[LdapLoginModule] tryFirstPass failed: " + le.toString());
            }
        } else if (this.useFirstPass) {
            try {
                this.attemptAuthentication(true);
                this.succeeded = true;
                if (this.debug) {
                    System.out.println("\t\t[LdapLoginModule] useFirstPass succeeded");
                }
                return true;
            }
            catch (LoginException le) {
                this.cleanState();
                if (this.debug) {
                    System.out.println("\t\t[LdapLoginModule] useFirstPass failed");
                }
                throw le;
            }
        }
lbl29:
        // 4 sources

        try {
            this.attemptAuthentication(false);
            this.succeeded = true;
            if (this.debug) {
                System.out.println("\t\t[LdapLoginModule] authentication succeeded");
            }
            return true;
        }
        catch (LoginException le) {
            this.cleanState();
            if (this.debug) {
                System.out.println("\t\t[LdapLoginModule] authentication failed");
            }
            throw le;
        }
    }

    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        this.cleanState();
        this.commitSucceeded = true;
        return true;
    }

    public boolean abort() throws LoginException {
        if (this.debug) {
            System.out.println("\t\t[LdapLoginModule] aborted authentication");
        }
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.cleanState();
        } else {
            this.logout();
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.subject.isReadOnly()) {
            this.cleanState();
            throw new LoginException("Subject is read-only");
        }
        this.cleanState();
        this.succeeded = false;
        this.commitSucceeded = false;
        if (this.debug) {
            System.out.println("\t\t[LdapLoginModule] logged out Subject");
        }
        return true;
    }

    private void attemptAuthentication(boolean getPasswdFromSharedState) throws LoginException {
        this.getUsernamePassword(getPasswdFromSharedState);
        if (this.password == null || this.password.length == 0) {
            throw new FailedLoginException("No password was supplied");
        }
        String dn = "";
        if (this.authFirst || this.authOnly) {
            String authId = this.replaceUsernameToken(this.identityMatcher, this.authIdentity);
            this.ldapEnvironment.put("java.naming.security.authentication", "simple");
            this.ldapEnvironment.put("java.naming.security.credentials", this.password);
            this.ldapEnvironment.put("java.naming.security.principal", authId);
            if (this.debug) {
                System.out.println("\t\t[LdapLoginModule] attempting to authenticate user: " + this.username);
            }
            try {
                this.ctx = new InitialLdapContext(this.ldapEnvironment, null);
            }
            catch (NamingException e) {
                throw (LoginException)new FailedLoginException("Cannot bind to LDAP server").initCause(e);
            }
            dn = this.userFilter != null ? this.findUserDN(this.ctx) : authId;
        } else {
            try {
                this.ctx = new InitialLdapContext(this.ldapEnvironment, null);
            }
            catch (NamingException e) {
                throw (LoginException)new FailedLoginException("Cannot connect to LDAP server").initCause(e);
            }
            dn = this.findUserDN(this.ctx);
            try {
                this.ctx.addToEnvironment("java.naming.security.authentication", "simple");
                this.ctx.addToEnvironment("java.naming.security.principal", dn);
                this.ctx.addToEnvironment("java.naming.security.credentials", this.password);
                if (this.debug) {
                    System.out.println("\t\t[LdapLoginModule] attempting to authenticate user: " + this.username);
                }
                this.ctx.reconnect(null);
            }
            catch (NamingException e) {
                throw (LoginException)new FailedLoginException("Cannot bind to LDAP server").initCause(e);
            }
        }
        if (this.storePass && !this.sharedState.containsKey(USERNAME_KEY) && !this.sharedState.containsKey(PASSWORD_KEY)) {
            this.sharedState.put(USERNAME_KEY, this.username);
            this.sharedState.put(PASSWORD_KEY, this.password);
        }
    }

    private String findUserDN(LdapContext ctx) throws LoginException {
        String userDN = "";
        if (this.userFilter != null) {
            if (this.debug) {
                System.out.println("\t\t[LdapLoginModule] searching for entry belonging to user: " + this.username);
            }
        } else {
            if (this.debug) {
                System.out.println("\t\t[LdapLoginModule] cannot search for entry belonging to user: " + this.username);
            }
            throw new FailedLoginException("Cannot find user's LDAP entry");
        }
        try {
            NamingEnumeration<SearchResult> results = ctx.search("", this.replaceUsernameToken(this.filterMatcher, this.userFilter), this.constraints);
            if (results.hasMore()) {
                SearchResult entry = results.next();
                userDN = ((Context)entry.getObject()).getNameInNamespace();
                if (this.debug) {
                    System.out.println("\t\t[LdapLoginModule] found entry: " + userDN);
                }
                results.close();
            } else if (this.debug) {
                System.out.println("\t\t[LdapLoginModule] user's entry not found");
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (userDN.equals("")) {
            throw new FailedLoginException("Cannot find user's LDAP entry");
        }
        return userDN;
    }

    private String replaceUsernameToken(Matcher matcher, String string) {
        return matcher != null ? matcher.replaceAll(this.username) : string;
    }

    private void getUsernamePassword(boolean getPasswdFromSharedState) throws LoginException {
        if (getPasswdFromSharedState) {
            this.username = (String)this.sharedState.get(USERNAME_KEY);
            this.password = (char[])this.sharedState.get(PASSWORD_KEY);
            return;
        }
        if (this.callbackHandler == null) {
            throw new LoginException("No CallbackHandler available to acquire authentication information from the user");
        }
        Callback[] callbacks = new Callback[]{new NameCallback("username: "), new PasswordCallback("password: ", false)};
        try {
            this.callbackHandler.handle(callbacks);
            this.username = ((NameCallback)callbacks[0]).getName();
            char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
            this.password = new char[tmpPassword.length];
            System.arraycopy(tmpPassword, 0, this.password, 0, tmpPassword.length);
            ((PasswordCallback)callbacks[1]).clearPassword();
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("Error: " + uce.getCallback().toString() + " not available to acquire authentication information" + " from the user");
        }
    }

    private void cleanState() {
        this.username = null;
        if (this.password != null) {
            Arrays.fill(this.password, ' ');
            this.password = null;
        }
        try {
            if (this.ctx != null) {
                this.ctx.close();
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        this.ctx = null;
        if (this.clearPass) {
            this.sharedState.remove(USERNAME_KEY);
            this.sharedState.remove(PASSWORD_KEY);
        }
    }
}

