/*
 * Decompiled with CFR 0.152.
 */
package com.sun.n1.sps.plugin.browse;

import com.raplix.util.message.MessageManager;
import com.sun.n1.sps.plugin.PluginMessage;
import com.sun.n1.sps.plugin.browse.BrowserException;
import com.sun.n1.sps.plugin.export.ComponentExportException;
import com.sun.n1.sps.plugin.export.SystemData;
import com.sun.n1.util.RPCSerializable;
import com.sun.n1.util.vars.PromptParamList;
import com.sun.n1.util.vars.VariableSettingsSource;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;

public class BrowserInfo
implements RPCSerializable {
    private String mComponentType;
    private String mBrowserClassNameVar;
    private String mBrowserType;
    private String mSysSrvcName;
    private String mPlatform;
    private String mHostSetName;
    private PromptParamList mParams;
    private Vector mClassPathEntries = new Vector();

    public BrowserInfo(String componentType, String browserType, String browserClassNameVar, String browserClassPathVar, String serviceName, String platform, String hostSetName, PromptParamList params) {
        this(componentType, browserType, browserClassNameVar, serviceName, platform, hostSetName, params);
        this.addToClassPathFromSystemService(serviceName, browserClassPathVar);
    }

    public BrowserInfo(String componentType, String browserType, String browserClassNameVar, String serviceName, String platform, String hostSetName, PromptParamList params) {
        this.mComponentType = componentType;
        this.mBrowserType = browserType;
        this.mBrowserClassNameVar = browserClassNameVar;
        this.mSysSrvcName = serviceName;
        this.mPlatform = platform;
        this.mHostSetName = hostSetName;
        this.mParams = params == null ? new PromptParamList() : (PromptParamList)params.clone();
    }

    private BrowserInfo() {
    }

    public void addToClassPathFromSystemService(String serviceName, String varName) {
        this.mClassPathEntries.add(new SystemServiceClassPathEntry(serviceName, varName));
    }

    public void addToClassPathFromPluginComponent(String varName) {
        this.mClassPathEntries.add(new PluginComponentClassPathEntry(varName));
    }

    public String getComponentType() {
        return this.mComponentType;
    }

    public String getBrowserType() {
        return this.mBrowserType;
    }

    public String getBrowserClassNameVar() {
        return this.mBrowserClassNameVar;
    }

    public String getServiceName() {
        return this.mSysSrvcName;
    }

    public String getPlatform() {
        return this.mPlatform;
    }

    public String getLimitToHostSet() {
        return this.mHostSetName;
    }

    public PromptParamList getCheckinOptions() {
        return (PromptParamList)this.mParams.clone();
    }

    public String getBrowserClassPath(SystemData sysData) throws BrowserException {
        String classPath = "";
        Iterator iter = this.mClassPathEntries.iterator();
        while (iter.hasNext()) {
            try {
                ClassPathEntry cpe = (ClassPathEntry)iter.next();
                String cp = cpe.getCPValue(sysData);
                classPath = classPath + (classPath.equals("") ? cp : ";" + cp);
            }
            catch (ComponentExportException e) {
                throw new BrowserException(e.getPluginMessage(), e.getCause());
            }
        }
        return classPath;
    }

    private static class ROXBundlePluginMessage
    extends PluginMessage {
        public ROXBundlePluginMessage(String msg, Object[] args) {
            super(msg, args);
        }

        public String getMessageValue(Locale inLocale) {
            return MessageManager.messageAsString(this.getKey(), inLocale);
        }
    }

    private static final class PluginComponentClassPathEntry
    implements ClassPathEntry {
        private String mVarName;

        private PluginComponentClassPathEntry() {
        }

        private PluginComponentClassPathEntry(String varName) {
            this.mVarName = varName;
        }

        public String getCPValue(SystemData sysData) throws BrowserException, ComponentExportException {
            String val;
            VariableSettingsSource pcVars = sysData.getPluginComponentVars();
            String string = val = pcVars == null ? null : pcVars.getVarValue(this.mVarName);
            if (val == null) {
                throw new BrowserException(new ROXBundlePluginMessage("hierarchies.NULL_CLASSPATH_ENTRY_PC", new Object[]{this.mVarName}));
            }
            return val;
        }
    }

    private static final class SystemServiceClassPathEntry
    implements ClassPathEntry {
        private String mSSName;
        private String mVarName;

        private SystemServiceClassPathEntry() {
        }

        private SystemServiceClassPathEntry(String ssName, String varName) {
            this.mSSName = ssName;
            this.mVarName = varName;
        }

        public String getCPValue(SystemData sysData) throws BrowserException, ComponentExportException {
            String val;
            VariableSettingsSource ssVars = sysData.getSystemServiceVars(this.mSSName);
            String string = val = ssVars == null ? null : ssVars.getVarValue(this.mVarName);
            if (val == null) {
                throw new BrowserException(new ROXBundlePluginMessage("hierarchies.NULL_CLASSPATH_ENTRY_SS", new Object[]{this.mSSName, this.mVarName}));
            }
            return val;
        }
    }

    private static interface ClassPathEntry
    extends RPCSerializable {
        public String getCPValue(SystemData var1) throws BrowserException, ComponentExportException;
    }
}

