/*
 * Decompiled with CFR 0.152.
 */
package com.sun.n1.sps.client;

import [Ljava.lang.String;;
import com.sun.n1.sps.client.CommandManager;
import com.sun.n1.sps.client.ConfigurationException;
import com.sun.n1.sps.model.util.ClientException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class CommandManagerBuilder {
    private File mCLIInstDir;
    private File mLibDir;
    private File mBootStrapJar;
    private URLClassLoader mClassLoader;
    private boolean mTestConnection = false;
    private final PublicAPIMessageManager mMessenger = new PublicAPIMessageManager();
    private String mLibOverride = null;
    private String msPortOverride = null;
    private static String mCLUIBuildNumber = null;
    private static final String BS_JAR = "cr_bs.jar";
    private static final String RESOURCE_CATALOG = "api_messages";
    private static final String ROX_HOME_DIR_CONFIG_FLAG = "rox_home_dir";
    private static final String BOOT_STRAP_CLASS = "com.raplix.rolloutexpress.node.bootstrap.BootStrap";
    private static final String COMMAND_MANAGER_IMPL_CLASS = "com.raplix.rolloutexpress.ui.api.CommandManagerImpl";
    private static final String IN_TEST_MODE = "-inTestMode";
    private static final String CLI_INST_FLAG = "-path";
    private static final String LIB_OVERRIDE_FLAG = "-libOverride";
    private static final String MS_PORT_OVERRIDE_FLAG = "-msPort";
    private static final String APP_IMPL_OVERRIDE_FLAG = "-appImpl";
    private static final String LIBDIR_OVERRIDE = "cmb.liboverride";
    private static final String MS_PORT_OVERRIDE = "cmb.ms.port.override";
    private static final String BS_LIBDIR_OVERRIDE = "cr.bs.liboverride";
    private static final String APP_IMPL_DIR_CONFIG_FLAG = "rox_appimpl_dir";
    private static final String DEF_CLUI_CONFIG = "ui" + File.separator + "clui.config";
    private static final String MESSAGE_NOT_FOUND_KEY = "messageNotFound";
    private static final String MESSAGE_NOT_FOUND_MESSAGE = "The message could not be looked up. Please make sure the message catalog file exist and is readable.";
    private static final String PACKAGE_PREFIX = "cmb.";
    public static final String MSG_SET_CLI_MSG = "cmb.SET_CLI_MSG";
    public static final String MSG_CMD_MGR_REF_ERROR = "cmb.CMD_MGR_REF_ERROR";
    public static final String MSG_SYNCHRONIZATION_ERROR = "cmb.SYNCHRONIZATION_ERROR";
    public static final String MSG_INVALID_CLI_DIR_ERROR = "cmb.INVALID_CLI_DIR_ERROR";
    public static final String MSG_INVALID_CLI_LIB_DIR_ERROR = "cmb.INVALID_CLI_LIB_DIR_ERROR";
    public static final String MSG_ERROR_CREATING_TMP_FILES = "cmb.ERROR_CREATING_TMP_FILES";
    public static final String MSG_INVALID_BS_JAR_FILE_ERROR = "cmb.INVALID_BS_JAR_FILE_ERROR";
    public static final String MSG_INCOMPATIBLE_VERSION_ERROR = "cmb.INCOMPATIBLE_VERSION_ERROR";
    public static final String MSG_UNABLE_VERSION_ERROR = "cmb.UNABLE_VERSION_ERROR";
    public static final String MSG_TEST_CONNECTION_FAILURE_ERROR = "cmb.TEST_CONNECTION_FAILURE_ERROR";
    private static final String MSG_PATH_SWITCH = "cmb.PATH_SWITCH";
    private static final String MSG_VERSION_SWITCH = "cmb.VERSION_SWITCH";
    private static final String MSG_VERSION_HEADER = "cmb.VERSION_HEADER";
    private static final String MSG_BUILD_HEADER = "cmb.BUILD_HEADER";
    public static String API_VERSION = "5.2.1";

    public void setCLIInstallationDir(File inCLIInstDir) throws ConfigurationException {
        this.verifyCLIInstallationDir(inCLIInstDir);
        this.mCLIInstDir = inCLIInstDir;
        this.setBootStrapJar();
    }

    public File getCLIInstallationDir() {
        return this.mCLIInstDir;
    }

    public void setTestConnection(boolean inTestConnection) {
        this.mTestConnection = inTestConnection;
    }

    public boolean getTestConnection() {
        return this.mTestConnection;
    }

    public CommandManager build() throws ConfigurationException, ClientException {
        if (!this.isCLIDirSet()) {
            throw new ConfigurationException(this.getLocalizedMessage(MSG_SET_CLI_MSG, new Object[0]));
        }
        this.mClassLoader = this.bootStrap();
        return this.getCommandManager(this.mClassLoader);
    }

    public URLClassLoader getClassLoader() {
        return this.mClassLoader;
    }

    public static String getVersion() {
        return API_VERSION;
    }

    private void verifyCLIInstallationDir(File inCLIInstDir) throws ConfigurationException {
        if (!inCLIInstDir.exists() || !inCLIInstDir.isDirectory()) {
            throw new ConfigurationException(this.getLocalizedMessage(MSG_INVALID_CLI_DIR_ERROR, new Object[]{inCLIInstDir.getAbsolutePath()}));
        }
        if (this.mLibOverride == null) {
            this.mLibOverride = System.getProperty(LIBDIR_OVERRIDE);
        }
        if (this.mLibOverride == null || this.mLibOverride.length() == 0) {
            try {
                this.mLibDir = new File(new File(new File(inCLIInstDir, ".."), "common"), "lib").getCanonicalFile();
            }
            catch (IOException io) {
                throw new ConfigurationException(this.getLocalizedMessage(MSG_INVALID_CLI_DIR_ERROR, new Object[]{inCLIInstDir.getAbsolutePath()}), io);
            }
        } else {
            this.mLibDir = new File(this.mLibOverride);
        }
        if (!this.mLibDir.exists() || !this.mLibDir.isDirectory()) {
            throw new ConfigurationException(this.getLocalizedMessage(MSG_INVALID_CLI_DIR_ERROR, new Object[]{inCLIInstDir.getAbsolutePath()}));
        }
    }

    private void setBootStrapJar() throws ConfigurationException {
        File[] jars = this.mLibDir.listFiles(BootStrapJarFilter.INSTANCE);
        if (null == jars || jars.length != 1) {
            throw new ConfigurationException(this.getLocalizedMessage(MSG_INVALID_CLI_DIR_ERROR, new Object[]{this.mLibDir.getAbsolutePath()}));
        }
        this.mBootStrapJar = jars[0];
    }

    private boolean isCLIDirSet() {
        return this.mBootStrapJar != null && this.mBootStrapJar.getName().equals(BS_JAR);
    }

    private Class loadBootStrap() throws ConfigurationException {
        Class<?> bootLoaderClass;
        ClassLoader cls = this.getClassLoader(this.mBootStrapJar);
        try {
            bootLoaderClass = cls.loadClass(BOOT_STRAP_CLASS);
            Constructor<?> mainMethod = bootLoaderClass.getDeclaredConstructor(new Class[0]);
            mainMethod.setAccessible(true);
            mainMethod.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException(this.getLocalizedMessage(MSG_SYNCHRONIZATION_ERROR, new Object[0]), e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(this.getLocalizedMessage(MSG_SYNCHRONIZATION_ERROR, new Object[0]), e);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException(this.getLocalizedMessage(MSG_SYNCHRONIZATION_ERROR, new Object[0]), e);
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException(this.getLocalizedMessage(MSG_SYNCHRONIZATION_ERROR, new Object[0]), e);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException(this.getLocalizedMessage(MSG_SYNCHRONIZATION_ERROR, new Object[0]), e);
        }
        return bootLoaderClass;
    }

    private Object getBootStrapObj(Class inBootStrapClass) throws NoSuchMethodException, ConfigurationException, IllegalAccessException, InvocationTargetException {
        Method getInstance = inBootStrapClass.getMethod("getInstance", null);
        getInstance.setAccessible(true);
        if (!Modifier.isStatic(getInstance.getModifiers()) || !getInstance.getReturnType().equals(inBootStrapClass)) {
            throw new ConfigurationException(this.getLocalizedMessage(MSG_SYNCHRONIZATION_ERROR, new Object[0]));
        }
        return getInstance.invoke(null, new Object[0]);
    }

    private URLClassLoader bootStrap() throws ConfigurationException {
        System.setProperty(ROX_HOME_DIR_CONFIG_FLAG, this.mCLIInstDir.getAbsolutePath());
        Object classLoader = null;
        Class bootStrapClass = this.loadBootStrap();
        try {
            Object bootStrapObj = this.getBootStrapObj(bootStrapClass);
            Field field = bootStrapClass.getDeclaredField("mMainClass");
            field.setAccessible(true);
            field.set(bootStrapObj, CommandManagerBuilder.class.getName());
            field = bootStrapClass.getDeclaredField("mHomeDir");
            field.setAccessible(true);
            field.set(bootStrapObj, this.mCLIInstDir.getAbsolutePath());
            field = bootStrapClass.getDeclaredField("mUseParentClassLoader");
            field.setAccessible(true);
            field.set(bootStrapObj, new Boolean(true));
            Method method = bootStrapClass.getDeclaredMethod("run", new Class[0]);
            method.setAccessible(true);
            method.invoke(bootStrapObj, new Object[0]);
            method = bootStrapClass.getDeclaredMethod("getClassLoader", new Class[0]);
            method.setAccessible(true);
            classLoader = method.invoke(bootStrapObj, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException(this.getLocalizedMessage(MSG_SYNCHRONIZATION_ERROR, new Object[0]), e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(this.getLocalizedMessage(MSG_SYNCHRONIZATION_ERROR, new Object[0]), e);
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException(this.getLocalizedMessage(MSG_SYNCHRONIZATION_ERROR, new Object[0]), e);
        }
        catch (NoSuchFieldException e) {
            throw new ConfigurationException(this.getLocalizedMessage(MSG_SYNCHRONIZATION_ERROR, new Object[0]), e);
        }
        if (classLoader != null && !(classLoader instanceof URLClassLoader)) {
            throw new ConfigurationException(this.getLocalizedMessage(MSG_SYNCHRONIZATION_ERROR, new Object[0]));
        }
        return (URLClassLoader)classLoader;
    }

    private ClassLoader getClassLoader(File jarFile) throws ConfigurationException {
        URL[] urls = new URL[1];
        try {
            urls[0] = jarFile.toURL();
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException(this.getLocalizedMessage(MSG_INVALID_BS_JAR_FILE_ERROR, new Object[]{jarFile.getAbsolutePath()}), e);
        }
        URLClassLoader mClassLoader = new URLClassLoader(urls, this.getClass().getClassLoader());
        return mClassLoader;
    }

    private CommandManager getCommandManager(URLClassLoader inCmdMgrLoader) throws ConfigurationException, ClientException {
        Object cmObj = null;
        Class<?> cmdMgrImpl = null;
        try {
            try {
                cmdMgrImpl = inCmdMgrLoader.loadClass(COMMAND_MANAGER_IMPL_CLASS);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException(this.getLocalizedMessage(MSG_UNABLE_VERSION_ERROR, new Object[]{this.mCLIInstDir.getAbsolutePath()}), e);
            }
            if (this.msPortOverride == null) {
                this.msPortOverride = System.getProperty(MS_PORT_OVERRIDE);
            }
            if (this.msPortOverride == null || this.msPortOverride.length() == 0) {
                Constructor<?> con = cmdMgrImpl.getDeclaredConstructor(CommandManagerBuilder.class);
                con.setAccessible(true);
                cmObj = con.newInstance(this);
            } else {
                Constructor<?> con = cmdMgrImpl.getDeclaredConstructor(String;.class, CommandManagerBuilder.class);
                con.setAccessible(true);
                cmObj = con.newInstance(this.getClientConnections(this.msPortOverride), this);
            }
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(this.getLocalizedMessage(MSG_SYNCHRONIZATION_ERROR, new Object[0]), e);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException(this.getLocalizedMessage(MSG_SYNCHRONIZATION_ERROR, new Object[0]), e);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new ConfigurationException(this.getLocalizedMessage(MSG_SYNCHRONIZATION_ERROR, new Object[0]), e);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException(this.getLocalizedMessage(MSG_SYNCHRONIZATION_ERROR, new Object[0]), e);
        }
        if (cmObj == null || !(cmObj instanceof CommandManager)) {
            throw new ConfigurationException(MSG_CMD_MGR_REF_ERROR);
        }
        this.checkVersion(cmdMgrImpl);
        if (this.getTestConnection()) {
            this.testConnection(cmdMgrImpl, cmObj);
        }
        return cmObj;
    }

    private void checkVersion(Class inCMImpl) throws ConfigurationException {
        Boolean isCompatible;
        String cliVersion;
        try {
            Method method = inCMImpl.getDeclaredMethod("getCluiVersion", new Class[0]);
            method.setAccessible(true);
            cliVersion = (String)method.invoke(null, new Object[0]);
            method = inCMImpl.getDeclaredMethod("getBuildNumber", new Class[0]);
            method.setAccessible(true);
            mCLUIBuildNumber = (String)method.invoke(null, new Object[0]);
            method = inCMImpl.getDeclaredMethod("checkVersion", String.class);
            method.setAccessible(true);
            isCompatible = (Boolean)method.invoke(null, API_VERSION);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException(this.getLocalizedMessage(MSG_SYNCHRONIZATION_ERROR, new Object[0]), e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(this.getLocalizedMessage(MSG_SYNCHRONIZATION_ERROR, new Object[0]), e);
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException(this.getLocalizedMessage(MSG_SYNCHRONIZATION_ERROR, new Object[0]), e);
        }
        if (isCompatible == null || !isCompatible.booleanValue()) {
            throw new ConfigurationException(this.getLocalizedMessage(MSG_INCOMPATIBLE_VERSION_ERROR, new Object[]{cliVersion, API_VERSION}));
        }
    }

    private void testConnection(Class inCMImpl, Object inCMImplObj) throws ConfigurationException {
        try {
            Method method = inCMImpl.getDeclaredMethod("pingServer", new Class[0]);
            method.setAccessible(true);
            method.invoke(inCMImplObj, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException(this.getLocalizedMessage(MSG_TEST_CONNECTION_FAILURE_ERROR, new Object[]{e.getTargetException().getMessage()}));
        }
        catch (Exception e) {
            throw new ConfigurationException(this.getLocalizedMessage(MSG_TEST_CONNECTION_FAILURE_ERROR, new Object[]{e.getMessage()}));
        }
    }

    private String getLocalizedMessage(String catalogue, Object[] args) {
        return this.mMessenger.messageAsString(catalogue, args);
    }

    private String[] getClientConnections(String inMSPort) {
        return new String[]{"-Dnet.client.port.1=" + inMSPort, "-O" + DEF_CLUI_CONFIG};
    }

    private static void printUsage() {
        String usage = "Usage:\n\njava -jar sps-api.jar -path cli_path -version\njava -jar sps-api.jar -h\n\twhere cli_path points to a valid SPS CLI installation directory.";
        System.out.println(usage);
        System.exit(0);
    }

    private static String getParam(String[] args, String key) {
        String ret = null;
        for (int x = 0; x < args.length; ++x) {
            if (!args[x].equals(key) || x + 1 >= args.length || args[x + 1] == null || args[x + 1].length() <= 0) continue;
            ret = args[x + 1];
            break;
        }
        return ret;
    }

    private static boolean containsParam(String[] args, String key, boolean checkHasValue) {
        boolean contains = false;
        for (int x = 0; x < args.length; ++x) {
            if (!args[x].equals(key)) continue;
            if (checkHasValue) {
                if (x + 1 < args.length && args[x + 1] != null && args[x + 1].length() > 0) {
                    contains = true;
                    break;
                }
                contains = false;
                continue;
            }
            contains = true;
            break;
        }
        return contains;
    }

    private static String getRoxHome() {
        return ROX_HOME_DIR_CONFIG_FLAG;
    }

    public static void main(String[] args) throws Exception {
        if (args == null || args.length == 0) {
            return;
        }
        CommandManagerBuilder cmb = new CommandManagerBuilder();
        if (CommandManagerBuilder.containsParam(args, IN_TEST_MODE, false)) {
            String cliInstPath = CommandManagerBuilder.getParam(args, CLI_INST_FLAG);
            File cliInst = new File(cliInstPath);
            if (!cliInst.exists()) {
                System.exit(1);
            }
            String libOverride = CommandManagerBuilder.getParam(args, LIB_OVERRIDE_FLAG);
            String portOverride = CommandManagerBuilder.getParam(args, MS_PORT_OVERRIDE_FLAG);
            if (libOverride == null || portOverride == null) {
                System.exit(2);
            }
            System.setProperty(BS_LIBDIR_OVERRIDE, libOverride);
            String appImplOverride = CommandManagerBuilder.getParam(args, APP_IMPL_OVERRIDE_FLAG);
            if (appImplOverride == null) {
                System.exit(3);
            }
            System.setProperty(APP_IMPL_DIR_CONFIG_FLAG, appImplOverride);
            System.setProperty("rox_winutils_dir", appImplOverride);
            cmb.mLibOverride = libOverride;
            cmb.msPortOverride = portOverride;
            cmb.setCLIInstallationDir(cliInst);
            cmb.setTestConnection(true);
            CommandManager cm = cmb.build();
            if (cmb.getClass().getClassLoader() != cm.getClass().getClassLoader().getParent().getParent()) {
                System.exit(4);
            }
            System.exit(0);
        } else if (CommandManagerBuilder.containsParam(args, cmb.getLocalizedMessage(MSG_PATH_SWITCH, new Object[0]), true) && CommandManagerBuilder.containsParam(args, cmb.getLocalizedMessage(MSG_VERSION_SWITCH, new Object[0]), false)) {
            String path = CommandManagerBuilder.getParam(args, cmb.getLocalizedMessage(MSG_PATH_SWITCH, new Object[0]));
            if (path.equals(cmb.getLocalizedMessage(MSG_VERSION_SWITCH, new Object[0]))) {
                CommandManagerBuilder.printUsage();
            }
            cmb.setCLIInstallationDir(new File(path));
            cmb.build();
            if (mCLUIBuildNumber == null) {
                System.out.println(cmb.getLocalizedMessage(MSG_UNABLE_VERSION_ERROR, new Object[]{CommandManagerBuilder.getParam(args, cmb.getLocalizedMessage(MSG_PATH_SWITCH, new Object[0]))}));
                System.exit(1);
            }
            System.out.println(cmb.getLocalizedMessage(MSG_VERSION_HEADER, new Object[]{API_VERSION}));
            System.out.println(cmb.getLocalizedMessage(MSG_BUILD_HEADER, new Object[]{mCLUIBuildNumber}));
        } else {
            CommandManagerBuilder.printUsage();
        }
    }

    static final class PublicAPIMessageManager {
        PublicAPIMessageManager() {
        }

        private final ResourceBundle getResources(Locale inLocale) {
            return ResourceBundle.getBundle(CommandManagerBuilder.RESOURCE_CATALOG, inLocale);
        }

        private String messageAsString(String inKeyName, Object[] inArgs) {
            String token;
            if (null == inKeyName || 0 == inKeyName.length()) {
                return "";
            }
            try {
                token = this.getToken(inKeyName, this.getDefaultLocale());
            }
            catch (MissingResourceException mre1) {
                try {
                    return this.getToken(CommandManagerBuilder.MESSAGE_NOT_FOUND_KEY, this.getDefaultLocale());
                }
                catch (MissingResourceException mre2) {
                    return CommandManagerBuilder.MESSAGE_NOT_FOUND_MESSAGE;
                }
            }
            String output = token;
            if (null != inArgs) {
                MessageFormat message = new MessageFormat(token);
                message.setLocale(this.getDefaultLocale());
                output = message.format(inArgs);
            }
            return output;
        }

        private String getToken(String inKeyName, Locale inLocale) throws MissingResourceException {
            return this.getResources(inLocale).getString(inKeyName);
        }

        public Locale getDefaultLocale() {
            return Locale.getDefault();
        }
    }

    private static final class BootStrapJarFilter
    implements FileFilter {
        public static final BootStrapJarFilter INSTANCE = new BootStrapJarFilter();

        private BootStrapJarFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.isFile() && pathname.getName().equals(CommandManagerBuilder.BS_JAR);
        }
    }
}

