/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.unicode;

import com.raplix.util.unicode.Encoding;
import com.raplix.util.unicode.EncodingRepository;
import com.raplix.util.unicode.UnicodeInputStreamReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class UnicodeOutputStreamWriter
extends Writer {
    private OutputStream mStream;
    private OutputStreamWriter mWriter;
    private String mEncoding;
    private Encoding mSigner;

    public UnicodeOutputStreamWriter(OutputStream stream) {
        super(stream);
        this.mStream = stream;
    }

    public UnicodeOutputStreamWriter(OutputStream stream, String encoding) {
        this(stream);
        this.mEncoding = encoding;
    }

    public UnicodeOutputStreamWriter(OutputStream stream, Reader reader) throws IOException {
        this(stream);
        Encoding e;
        if (reader instanceof UnicodeInputStreamReader && (e = ((UnicodeInputStreamReader)reader).getSigner()) != null) {
            this.mEncoding = e.getName();
        }
    }

    private void ensureOpen() throws IOException {
        if (this.mStream == null) {
            throw new IOException("Stream closed");
        }
        if (this.mWriter != null) {
            return;
        }
        Encoding e = null;
        if (this.mEncoding != null && (e = EncodingRepository.getGlobalInstance().find(this.mEncoding)) != null) {
            try {
                this.mStream.write(e.getSignature());
                this.mSigner = e;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        this.mWriter = this.mEncoding == null ? new OutputStreamWriter(this.mStream) : new OutputStreamWriter(this.mStream, this.mEncoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEncoding() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            return this.mWriter.getEncoding();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Encoding getSigner() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            return this.mSigner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.mStream == null) {
                return;
            }
            if (this.mWriter != null) {
                this.mWriter.close();
            }
            this.mStream.close();
            this.mStream = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int c) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.mWriter.write(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.mWriter.write(cbuf, off, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cbuf) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.mWriter.write(cbuf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String str, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.mWriter.write(str, off, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String str) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.mWriter.write(str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.mWriter.flush();
        }
    }
}

