/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.unicode;

import com.raplix.util.unicode.Encoding;
import com.raplix.util.unicode.EncodingRepository;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class UnicodeInputStreamReader
extends Reader {
    private BufferedInputStream mStream;
    private InputStreamReader mReader;
    private String mEncoding;
    private Encoding mSigner;

    public UnicodeInputStreamReader(InputStream stream) {
        super(stream);
        this.mStream = new BufferedInputStream(stream);
    }

    public UnicodeInputStreamReader(InputStream stream, String encoding) {
        this(stream);
        this.mEncoding = encoding;
    }

    private void ensureOpen() throws IOException {
        if (this.mStream == null) {
            throw new IOException("Stream closed");
        }
        if (this.mReader != null) {
            return;
        }
        EncodingRepository r = EncodingRepository.getGlobalInstance();
        byte[] signature = new byte[r.getLongestSignature()];
        this.mStream.mark(signature.length + 1);
        int count = this.mStream.read(signature);
        this.mStream.reset();
        if (count != -1) {
            Encoding e;
            if (count != signature.length) {
                byte[] signatureActual = new byte[count];
                System.arraycopy(signature, 0, signatureActual, 0, count);
                signature = signatureActual;
            }
            if ((e = r.find(signature)) != null) {
                this.mStream.read(signature, 0, e.getSignature().length);
                try {
                    this.mReader = new InputStreamReader((InputStream)this.mStream, e.getName());
                    this.mSigner = e;
                    return;
                }
                catch (UnsupportedEncodingException ignored) {
                    this.mStream.reset();
                }
            }
        }
        this.mReader = this.mEncoding == null ? new InputStreamReader(this.mStream) : new InputStreamReader((InputStream)this.mStream, this.mEncoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEncoding() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            return this.mReader.getEncoding();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Encoding getSigner() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            return this.mSigner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.mStream == null) {
                return;
            }
            if (this.mReader != null) {
                this.mReader.close();
            }
            this.mStream.close();
            this.mStream = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            return this.mReader.ready();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            return this.mReader.read();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            return this.mReader.read(cbuf, off, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cbuf) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            return this.mReader.read(cbuf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            return this.mReader.skip(n);
        }
    }

    public boolean markSupported() {
        return this.mReader.markSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int readAheadLimit) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.mReader.mark(readAheadLimit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.mReader.reset();
        }
    }
}

