/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.unicode;

import com.raplix.util.file.CopyUtil;
import com.raplix.util.logger.Logger;
import com.raplix.util.message.MessageManager;
import com.raplix.util.string.UnicodeEscape;
import com.raplix.util.unicode.UnicodeFileReader;
import com.raplix.util.unicode.UnicodeFileWriter;
import java.io.IOException;

public class Native2Ascii {
    private static String MSG_GENERAL_ERROR = "util.unicode.NATIVE2ASCII_ERROR_GENERAL";
    public static final String OUT_FILE_ENCODING = "ISO-8859-1";

    private Native2Ascii() {
    }

    public static void main(String[] args) {
        Logger.initializeLoggingSystem();
        try {
            Native2Ascii.run(args);
        }
        catch (Throwable t) {
            if (Logger.isErrorEnabled(Native2Ascii.class)) {
                Logger.error(MessageManager.messageAsString(MSG_GENERAL_ERROR), t, Native2Ascii.class);
            }
            System.exit(1);
        }
    }

    private static void run(String[] args) throws Exception {
        String inFile = args[0];
        String outFile = args[1];
        Native2Ascii.convert(inFile, outFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert(String inFile, String outFile) throws IOException {
        String fileContents = "";
        UnicodeFileReader ufr = new UnicodeFileReader(inFile);
        try {
            fileContents = new String(CopyUtil.readText(ufr));
        }
        finally {
            ufr.close();
        }
        UnicodeFileWriter ufw = new UnicodeFileWriter(outFile, OUT_FILE_ENCODING);
        try {
            UnicodeEscape escaper = UnicodeEscape.getGlobalInstance();
            String encoded = escaper.escape(fileContents);
            ufw.write(encoded);
        }
        finally {
            ufw.close();
        }
    }
}

