/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.unicode;

import com.raplix.util.unicode.Encoding;
import java.io.UnsupportedEncodingException;

public class EncodingRepository {
    private static final EncodingRepository REPOSITORY = new EncodingRepository(new Encoding[]{Encoding.UTF8, Encoding.UTF16BE, Encoding.UTF16LE, Encoding.UTF32BE, Encoding.UTF32LE});
    private Encoding[] mEncodings;

    public EncodingRepository(Encoding[] encodings) {
        this.mEncodings = encodings;
    }

    public Encoding[] getEncodings() {
        return this.mEncodings;
    }

    public Encoding find(String encoding) {
        if (encoding == null) {
            return null;
        }
        for (int i = 0; i < this.getEncodings().length; ++i) {
            Encoding e = this.getEncodings()[i];
            if (!encoding.equals(e.getName())) continue;
            return e;
        }
        return null;
    }

    public Encoding find(byte[] array) {
        if (array == null) {
            return null;
        }
        int maxMatchLen = -1;
        Encoding match = null;
        for (int i = 0; i < this.getEncodings().length; ++i) {
            Encoding e = this.getEncodings()[i];
            int len = e.getSignature().length;
            if (!e.matches(array) || len <= maxMatchLen) continue;
            maxMatchLen = len;
            match = e;
        }
        return match;
    }

    public byte[] apply(String string, String encoding) throws UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        if (encoding == null) {
            return string.getBytes();
        }
        Encoding e = this.find(encoding);
        if (e != null) {
            return e.applySignature(string);
        }
        return string.getBytes(encoding);
    }

    public String apply(byte[] array, String encoding) throws UnsupportedEncodingException {
        if (array == null) {
            return null;
        }
        Encoding e = this.find(array);
        if (e != null) {
            return e.applySignature(array);
        }
        if (encoding != null) {
            return new String(array, encoding);
        }
        return new String(array);
    }

    int getLongestSignature() {
        int maxLen = -1;
        for (int i = 0; i < this.getEncodings().length; ++i) {
            int len = this.getEncodings()[i].getSignature().length;
            if (len <= maxLen) continue;
            maxLen = len;
        }
        return maxLen;
    }

    public static EncodingRepository getGlobalInstance() {
        return REPOSITORY;
    }
}

