/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.unicode;

import java.io.UnsupportedEncodingException;

public class Encoding {
    private static final byte[] SUPPORT_TEST = new byte[0];
    public static final Encoding UTF8 = new Encoding("UTF-8", new byte[]{-17, -69, -65});
    public static final Encoding UTF16BE = new Encoding("UTF-16BE", new byte[]{-2, -1});
    public static final Encoding UTF16LE = new Encoding("UTF-16LE", new byte[]{-1, -2});
    public static final Encoding UTF32BE = new Encoding("UTF-32BE", new byte[]{0, 0, -2, -1});
    public static final Encoding UTF32LE = new Encoding("UTF-32LE", new byte[]{-1, -2, 0, 0});
    private String mName;
    private boolean mSupported;
    private byte[] mSignature;

    public Encoding(String name, byte[] signature) {
        this.mName = name;
        this.mSignature = signature;
        try {
            new String(SUPPORT_TEST, this.mName);
            this.mSupported = true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public String getName() {
        return this.mName;
    }

    public byte[] getSignature() {
        return this.mSignature;
    }

    public boolean isSupported() {
        return this.mSupported;
    }

    public boolean matches(byte[] array) {
        for (int i = 0; i < this.getSignature().length; ++i) {
            if (i != array.length && this.getSignature()[i] == array[i]) continue;
            return false;
        }
        return true;
    }

    public String applyNoSignature(byte[] array) throws UnsupportedEncodingException {
        if (array == null) {
            return null;
        }
        return new String(array, this.getName());
    }

    public byte[] applyNoSignature(String string) throws UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        return string.getBytes(this.getName());
    }

    public String applySignature(byte[] array) throws UnsupportedEncodingException {
        return new String(array, this.getSignature().length, array.length - this.getSignature().length, this.getName());
    }

    public byte[] applySignature(String string) throws UnsupportedEncodingException {
        byte[] stringBytes = string.getBytes(this.getName());
        byte[] result = new byte[this.getSignature().length + stringBytes.length];
        System.arraycopy(this.getSignature(), 0, result, 0, this.getSignature().length);
        System.arraycopy(stringBytes, 0, result, this.getSignature().length, stringBytes.length);
        return result;
    }

    public String toString() {
        return this.getName();
    }
}

