/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.unicode;

import com.raplix.util.unicode.Encoding;
import com.raplix.util.unicode.EncodingRepository;
import com.raplix.util.unicode.EncodingTranslator;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public class CachedMultibyteOutputStreamFilter
extends FilterOutputStream {
    private int mCacheSize;
    private ByteArrayOutputStream mCacheBuffer;
    private StringBuffer mCache;
    private String mEncoding = null;
    private CharsetDecoder mDecoder;
    private OutputStream mStream;
    private byte[] mSignature;
    private int mSignatureBytesWrittenSoFar;
    private int mCharsTruncated = 0;
    protected static final int UNLIMITED_CACHE = -1;

    public CachedMultibyteOutputStreamFilter(OutputStream inStream) {
        this(inStream, -1);
    }

    public CachedMultibyteOutputStreamFilter(OutputStream inStream, int inBufferSize) {
        this(inStream, inBufferSize, null);
    }

    public CachedMultibyteOutputStreamFilter(OutputStream inStream, String inEncoding) {
        this(inStream, -1, inEncoding);
    }

    public CachedMultibyteOutputStreamFilter(OutputStream inStream, int inBufferSize, String inEncoding) {
        super(inStream);
        this.mCacheSize = inBufferSize < 0 ? -1 : inBufferSize;
        this.mCacheBuffer = new ByteArrayOutputStream();
        this.mCache = new StringBuffer();
        this.mEncoding = inEncoding;
        this.mStream = inStream;
        this.mSignature = new byte[EncodingRepository.getGlobalInstance().getLongestSignature()];
        this.mSignatureBytesWrittenSoFar = 0;
        if (null == this.mEncoding) {
            this.mEncoding = CachedMultibyteOutputStreamFilter.getDefaultEncoding();
        }
        this.mEncoding = EncodingTranslator.translate(this.mEncoding);
        this.mDecoder = Charset.forName(this.mEncoding).newDecoder();
    }

    public int getCharsTruncated() {
        return this.mCharsTruncated;
    }

    public String getEncoding() {
        if (this.mEncoding == null) {
            return CachedMultibyteOutputStreamFilter.getDefaultEncoding();
        }
        return this.mEncoding;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.mStream.write(b, off, len);
        this.processByte(b, off, len);
    }

    public void write(int b) throws IOException {
        super.write(b);
        this.processByte(new byte[]{(byte)b}, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = this.mCache;
        synchronized (stringBuffer) {
            return this.mCache.toString();
        }
    }

    public void flush() throws IOException {
        this.mCacheBuffer.flush();
        super.flush();
    }

    public void close() throws IOException {
        if (this.mSignatureBytesWrittenSoFar < this.mSignature.length) {
            this.updateCache();
        }
        this.mCacheBuffer.close();
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTextToCache(String inText) {
        StringBuffer stringBuffer = this.mCache;
        synchronized (stringBuffer) {
            this.mCache.append(inText);
            if (this.mCacheSize != -1 && this.mCache.length() > this.mCacheSize) {
                this.mCharsTruncated += this.mCache.length() - this.mCacheSize;
                this.mCache.delete(0, this.mCache.length() - this.mCacheSize);
            }
        }
    }

    protected synchronized void processByte(byte[] b, int off, int len) throws IOException {
        this.mCacheBuffer.write(b, off, len);
        if (this.mSignatureBytesWrittenSoFar < this.mSignature.length) {
            int bytesToWrite = Math.min(len, this.mSignature.length - this.mSignatureBytesWrittenSoFar);
            System.arraycopy(b, off, this.mSignature, this.mSignatureBytesWrittenSoFar, bytesToWrite);
            this.mSignatureBytesWrittenSoFar += bytesToWrite;
            if (this.mSignatureBytesWrittenSoFar >= this.mSignature.length) {
                Encoding e = EncodingRepository.getGlobalInstance().find(this.mSignature);
                if (null != e) {
                    this.mEncoding = e.getName();
                    this.mDecoder = Charset.forName(this.mEncoding).newDecoder();
                }
                this.updateCache();
            }
        } else {
            this.updateCache();
        }
    }

    protected void updateCache() throws IOException {
        ByteBuffer bb = ByteBuffer.wrap(this.mCacheBuffer.toByteArray());
        CharBuffer cb = CharBuffer.allocate(bb.array().length);
        this.mDecoder.reset();
        this.mDecoder.decode(bb, cb, false);
        String rawText = new String(cb.array(), 0, cb.position());
        if (rawText.length() > 0) {
            this.addTextToCache(rawText);
            byte[] bPrime = this.mCacheBuffer.toByteArray();
            this.mCacheBuffer.reset();
            int rtBytes = (null == this.mEncoding ? rawText.getBytes() : rawText.getBytes(this.mEncoding)).length;
            if (rtBytes < bPrime.length) {
                this.mCacheBuffer.write(bPrime, rtBytes, bPrime.length - rtBytes);
            }
        }
    }

    public static String getDefaultEncoding() {
        return System.getProperty("file.encoding");
    }
}

