/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.threads;

import [Ljava.lang.String;;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.logger.Logger;
import com.raplix.util.threads.SafeThread;
import java.util.Enumeration;
import java.util.Vector;

public class TimeoutMonitor {
    private Vector mThreads = new Vector();

    protected void stopThread(Thread thread) {
        SafeThread.interruptSafe(thread);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Interrupted thread: '" + thread.getName() + "'", this);
        }
    }

    public void addThread(Thread thread) {
        this.mThreads.addElement(thread);
    }

    public void addThreadGroup(ThreadGroup threadGroup) {
        Thread[] threads = new Thread[threadGroup.activeCount()];
        threadGroup.enumerate(threads);
        for (int i = 0; i < threads.length; ++i) {
            if (threads[i] == null) {
                return;
            }
            this.addThread(threads[i]);
        }
    }

    public String[] monitor(long duration, long quantum) throws InterruptedException {
        Enumeration e;
        long end = System.currentTimeMillis() + duration;
        while (System.currentTimeMillis() < end) {
            Thread.sleep(quantum);
            boolean alive = false;
            e = this.mThreads.elements();
            while (e.hasMoreElements()) {
                if (!((Thread)e.nextElement()).isAlive()) continue;
                alive = true;
                break;
            }
            if (alive) continue;
            return new String[0];
        }
        Vector<String> aliveNames = new Vector<String>();
        e = this.mThreads.elements();
        while (e.hasMoreElements()) {
            Thread thread = (Thread)e.nextElement();
            if (!thread.isAlive()) continue;
            aliveNames.addElement(thread.getName());
            this.stopThread(thread);
        }
        return (String[])CollectionUtil.mapClass(aliveNames, String;.class);
    }

    public void join() throws InterruptedException {
        Enumeration e = this.mThreads.elements();
        while (e.hasMoreElements()) {
            ((Thread)e.nextElement()).join();
        }
    }
}

