/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.threads;

import [Ljava.lang.String;;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.logger.Logger;
import com.raplix.util.threads.PriorityMap;
import com.raplix.util.threads.SafeThread;
import com.raplix.util.threads.ThreadQueue;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public class ThrottleMonitor {
    private ThreadQueue mQueue;
    private LinkedList mAlive = new LinkedList();
    private Vector mStarted = new Vector();

    public ThrottleMonitor() {
        this.mQueue = new ThreadQueue();
    }

    public ThrottleMonitor(PriorityMap map) {
        this.mQueue = new ThreadQueue(map);
    }

    protected void stopThread(Thread thread) {
        SafeThread.interruptSafe(thread);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Interrupted thread: '" + thread.getName() + "'", this);
        }
    }

    public void addThread(Thread thread) {
        if (thread.isAlive()) {
            this.mStarted.addElement(thread);
            this.mAlive.add(thread);
        } else {
            this.mQueue.add(thread, null);
        }
    }

    public String[] monitor(long duration, long quantum, int throttle) throws InterruptedException {
        Thread thread;
        long end = System.currentTimeMillis() + duration;
        while (System.currentTimeMillis() < end) {
            int aliveCount = 0;
            Iterator i = this.mAlive.iterator();
            while (i.hasNext()) {
                if (((Thread)i.next()).isAlive()) {
                    ++aliveCount;
                    continue;
                }
                i.remove();
            }
            if (aliveCount == 0 && this.mQueue.size() == 0) {
                return new String[0];
            }
            for (int i2 = Math.min(this.mQueue.size(), throttle - aliveCount); i2 > 0; --i2) {
                thread = this.mQueue.remove().getThread();
                thread.start();
                this.mStarted.addElement(thread);
                this.mAlive.add(thread);
            }
            Thread.sleep(quantum);
        }
        Vector<String> aliveNames = new Vector<String>();
        Iterator i = this.mAlive.iterator();
        while (i.hasNext()) {
            thread = (Thread)i.next();
            if (!thread.isAlive()) continue;
            aliveNames.addElement(thread.getName());
            this.stopThread(thread);
        }
        i = this.mQueue.iterator();
        while (i.hasNext()) {
            aliveNames.addElement(((ThreadQueue.Entry)i.next()).getThread().getName());
        }
        return (String[])CollectionUtil.mapClass(aliveNames, String;.class);
    }

    public void join() throws InterruptedException {
        Enumeration e = this.mStarted.elements();
        while (e.hasMoreElements()) {
            ((Thread)e.nextElement()).join();
        }
    }
}

