/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.threads;

import com.raplix.util.ObjectUtil;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.collections.TreeCollection;
import com.raplix.util.threads.PrioritizedThread;
import com.raplix.util.threads.PriorityMap;
import java.util.Iterator;

public class ThreadQueue {
    private TreeCollection mQueue = new TreeCollection();
    private PriorityMap mMap;

    public ThreadQueue() {
    }

    public ThreadQueue(PriorityMap map) {
        this.mMap = map;
    }

    public void add(Thread t, Object data) {
        int p = -1;
        if (t instanceof PrioritizedThread) {
            p = ((PrioritizedThread)((Object)t)).getQueuePriority();
        }
        if (p == -1 && this.mMap != null) {
            p = this.mMap.getQueuePriority(t);
        }
        if (p == -1) {
            p = this.mQueue.size() == 0 ? 0 : ((Entry)this.mQueue.last()).getPriority() + 1;
        }
        this.mQueue.add(new Entry(t, p, data));
    }

    public boolean peek(Object data, int count) {
        Iterator i = this.iterator();
        while (i.hasNext() && count > 0) {
            if (((Entry)i.next()).getData() == data) {
                return true;
            }
            --count;
        }
        return false;
    }

    public Entry remove() {
        Entry e = (Entry)this.mQueue.first();
        this.mQueue.remove(e);
        return e;
    }

    public void remove(Object data) {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            if (!ObjectUtil.equals(data, ((Entry)i.next()).getData())) continue;
            i.remove();
            return;
        }
    }

    public int size() {
        return this.mQueue.size();
    }

    public Iterator iterator() {
        return this.mQueue.iterator();
    }

    public String toString() {
        return CollectionUtil.toString(this.mQueue, "", ",");
    }

    static class Entry
    implements Comparable {
        private Thread mThread;
        private int mPriority;
        private Object mData;

        Entry(Thread thread, int priority, Object data) {
            this.mThread = thread;
            this.mPriority = priority;
            this.mData = data;
        }

        Thread getThread() {
            return this.mThread;
        }

        int getPriority() {
            return this.mPriority;
        }

        Object getData() {
            return this.mData;
        }

        public int compareTo(Object o) {
            return this.getPriority() - ((Entry)o).getPriority();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append('(');
            buffer.append(this.getThread().getName());
            buffer.append(',');
            buffer.append(this.getPriority());
            if (this.getData() != null) {
                buffer.append(',');
                buffer.append(this.getData());
            }
            buffer.append(')');
            return buffer.toString();
        }
    }
}

