/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.threads;

import com.raplix.util.threads.PackageInfo;

public class SafeThread
extends Thread {
    private int mNestedLevel;
    private boolean mWasInterrupted;
    private Object mLock = new Object();

    public SafeThread() {
    }

    public SafeThread(Runnable target) {
        super(target);
    }

    public SafeThread(ThreadGroup group, Runnable target) {
        super(group, target);
    }

    public SafeThread(String name) {
        super(name);
    }

    public SafeThread(ThreadGroup group, String name) {
        super(group, name);
    }

    public SafeThread(Runnable target, String name) {
        super(target, name);
    }

    public SafeThread(ThreadGroup group, Runnable target, String name) {
        super(group, target, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enterSafe() {
        Object object = this.mLock;
        synchronized (object) {
            ++this.mNestedLevel;
            if (this.mNestedLevel == 1) {
                this.mWasInterrupted = SafeThread.interrupted();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leaveSafe() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mNestedLevel == 0) {
                PackageInfo.throwBadNesting(this);
            }
            --this.mNestedLevel;
            if (this.mNestedLevel == 0 && this.mWasInterrupted) {
                this.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptSafe() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mNestedLevel == 0) {
                this.interrupt();
            }
            this.mWasInterrupted = true;
        }
    }

    public static void interruptSafe(Thread thread) {
        if (thread instanceof SafeThread) {
            ((SafeThread)thread).interruptSafe();
        } else {
            thread.interrupt();
        }
    }

    public static void interruptSafeCurrent() {
        SafeThread.interruptSafe(Thread.currentThread());
    }
}

