/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.threads;

import com.raplix.util.logger.Logger;
import com.raplix.util.threads.Context;
import com.raplix.util.threads.PackageInfo;
import com.raplix.util.threads.ThreadAbortedException;
import java.util.Enumeration;
import java.util.Vector;

public abstract class RunnableContext
extends Context
implements Runnable {
    private Vector mListeners = new Vector();

    public RunnableContext(String name, Context context) {
        super(name, context);
    }

    protected abstract void safeRun() throws Exception;

    protected void testFlow() throws InterruptedException {
        this.testSuspend();
        this.testAbort();
    }

    protected void started() {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Execution started", this);
        }
    }

    protected void ended() {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Execution ended normally", this);
        }
    }

    protected void aborted(ThreadAbortedException ex) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Execution aborted normally", this);
        }
    }

    protected void failed(Throwable t) {
        if (Logger.isErrorEnabled(this)) {
            Logger.error(PackageInfo.createAbnormalEnd(), t, this);
        }
    }

    protected void releaseFailed(Throwable t) {
        if (Logger.isErrorEnabled(this)) {
            Logger.error(PackageInfo.createNoRelease(), t, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final void run() {
        block20: {
            Object v0;
            this.getParent().addFlowChild(this);
            this.started();
            this.safeRun();
            this.ended();
            Object var3_1 = null;
            try {
                try {
                    this.release();
                    v0 = null;
                }
                catch (Throwable t2) {
                    this.releaseFailed(t2);
                    v0 = null;
                }
            }
            catch (Throwable throwable) {
                v0 = null;
            }
            Object var6_13 = v0;
            this.getParent().removeFlowChild(this);
            Enumeration e22 = this.mListeners.elements();
            while (e22.hasMoreElements()) {
                ((EventListener)e22.nextElement()).ended(this);
            }
            {
                break block20;
                catch (ThreadAbortedException ex) {
                    Object v1;
                    this.aborted(ex);
                    Object var3_2 = null;
                    try {
                        try {
                            this.release();
                            v1 = null;
                        }
                        catch (Throwable t2) {
                            this.releaseFailed(t2);
                            v1 = null;
                        }
                    }
                    catch (Throwable throwable) {
                        v1 = null;
                    }
                    Object var6_14 = v1;
                    this.getParent().removeFlowChild(this);
                    e22 = this.mListeners.elements();
                    while (e22.hasMoreElements()) {
                        ((EventListener)e22.nextElement()).ended(this);
                    }
                    break block20;
                }
                catch (Throwable t) {
                    Object v2;
                    this.failed(t);
                    Object var3_3 = null;
                    try {
                        try {
                            this.release();
                            v2 = null;
                        }
                        catch (Throwable t2) {
                            this.releaseFailed(t2);
                            v2 = null;
                        }
                    }
                    catch (Throwable throwable) {
                        v2 = null;
                    }
                    Object var6_15 = v2;
                    this.getParent().removeFlowChild(this);
                    e22 = this.mListeners.elements();
                    while (e22.hasMoreElements()) {
                        ((EventListener)e22.nextElement()).ended(this);
                    }
                }
            }
            catch (Throwable throwable) {
                Object v3;
                Object var3_4 = null;
                try {
                    try {
                        this.release();
                        v3 = null;
                    }
                    catch (Throwable t2) {
                        this.releaseFailed(t2);
                        v3 = null;
                    }
                }
                catch (Throwable throwable2) {
                    v3 = null;
                }
                Object var6_16 = v3;
                this.getParent().removeFlowChild(this);
                e22 = this.mListeners.elements();
                while (e22.hasMoreElements()) {
                    ((EventListener)e22.nextElement()).ended(this);
                }
                throw throwable;
            }
        }
    }

    public void addListener(EventListener listener) {
        this.mListeners.addElement(listener);
    }

    public static interface EventListener {
        public void ended(RunnableContext var1);
    }
}

