/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.threads;

import com.raplix.util.threads.Resource;
import com.raplix.util.threads.ResourceID;
import com.raplix.util.threads.ResourceManager;
import com.raplix.util.threads.ResourceOwner;
import com.raplix.util.threads.ResourceUser;
import com.raplix.util.threads.ResourceUserItem;
import java.util.LinkedList;
import java.util.ListIterator;

class ResourceWrapper {
    private Resource mResource;
    private ResourceOwner mOwner;
    private LinkedList mUserItems = new LinkedList();

    public ResourceWrapper(Resource resource, ResourceOwner owner) {
        this.mResource = resource;
        this.mOwner = owner;
    }

    public Resource getResource() {
        return this.mResource;
    }

    public ResourceOwner getOwner() {
        return this.mOwner;
    }

    public void register(ResourceManager manager, ResourceID ID2) {
        this.mOwner.registered(manager, ID2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(ResourceManager manager, ResourceID ID2) throws Exception {
        try {
            LinkedList linkedList = this.mUserItems;
            synchronized (linkedList) {
                ListIterator i = this.mUserItems.listIterator();
                while (i.hasNext()) {
                    try {
                        ((ResourceUserItem)i.next()).release(manager, ID2, this.getResource());
                    }
                    finally {
                        i.remove();
                    }
                }
            }
        }
        finally {
            this.mOwner.unregistered(manager, ID2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object acquire(ResourceManager manager, ResourceID ID2, ResourceUser user) throws Exception {
        ResourceUserItem userItem = new ResourceUserItem(manager, ID2, this.getResource(), user);
        LinkedList linkedList = this.mUserItems;
        synchronized (linkedList) {
            this.mUserItems.add(userItem);
        }
        return userItem.getItem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object acquireNested(ResourceManager manager, ResourceID ID2, ResourceUser user, Object item) throws Exception {
        LinkedList linkedList = this.mUserItems;
        synchronized (linkedList) {
            ListIterator i = this.mUserItems.listIterator();
            while (i.hasNext()) {
                ResourceUserItem userItem = (ResourceUserItem)i.next();
                if (!userItem.matchesUser(user) || !userItem.matchesItem(item)) continue;
                userItem.setLevel(userItem.getLevel() + 1);
                return item;
            }
        }
        return this.acquire(manager, ID2, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object acquireNested(ResourceManager manager, ResourceID ID2, ResourceUser user) throws Exception {
        Object item = null;
        boolean acquired = false;
        LinkedList linkedList = this.mUserItems;
        synchronized (linkedList) {
            ListIterator i = this.mUserItems.listIterator();
            while (i.hasNext()) {
                ResourceUserItem userItem = (ResourceUserItem)i.next();
                if (!userItem.matchesUser(user)) continue;
                userItem.setLevel(userItem.getLevel() + 1);
                item = userItem.getItem();
                acquired = true;
            }
        }
        if (!acquired) {
            item = this.acquire(manager, ID2, user);
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(ResourceManager manager, ResourceID ID2, ResourceUser user, Object item) throws Exception {
        LinkedList linkedList = this.mUserItems;
        synchronized (linkedList) {
            ListIterator i = this.mUserItems.listIterator();
            while (i.hasNext()) {
                ResourceUserItem userItem = (ResourceUserItem)i.next();
                if (!userItem.matchesUser(user) || !userItem.matchesItem(item)) continue;
                try {
                    userItem.release(manager, ID2, this.getResource());
                }
                finally {
                    i.remove();
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseNested(ResourceManager manager, ResourceID ID2, ResourceUser user, Object item) throws Exception {
        LinkedList linkedList = this.mUserItems;
        synchronized (linkedList) {
            ListIterator i = this.mUserItems.listIterator();
            while (i.hasNext()) {
                ResourceUserItem userItem = (ResourceUserItem)i.next();
                if (!userItem.matchesUser(user) || !userItem.matchesItem(item)) continue;
                userItem.setLevel(userItem.getLevel() - 1);
                if (userItem.getLevel() == 0) {
                    try {
                        userItem.release(manager, ID2, this.getResource());
                    }
                    finally {
                        i.remove();
                    }
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(ResourceManager manager, ResourceID ID2, ResourceUser user) throws Exception {
        LinkedList linkedList = this.mUserItems;
        synchronized (linkedList) {
            ListIterator i = this.mUserItems.listIterator();
            while (i.hasNext()) {
                ResourceUserItem userItem = (ResourceUserItem)i.next();
                if (!userItem.matchesUser(user)) continue;
                try {
                    userItem.release(manager, ID2, this.getResource());
                }
                finally {
                    i.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseNested(ResourceManager manager, ResourceID ID2, ResourceUser user) throws Exception {
        LinkedList linkedList = this.mUserItems;
        synchronized (linkedList) {
            ListIterator i = this.mUserItems.listIterator();
            while (i.hasNext()) {
                ResourceUserItem userItem = (ResourceUserItem)i.next();
                if (!userItem.matchesUser(user)) continue;
                userItem.setLevel(userItem.getLevel() - 1);
                if (userItem.getLevel() != 0) continue;
                try {
                    userItem.release(manager, ID2, this.getResource());
                }
                finally {
                    i.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('[');
        buffer.append(this.mResource);
        buffer.append(';');
        buffer.append(this.mOwner);
        LinkedList linkedList = this.mUserItems;
        synchronized (linkedList) {
            if (this.mUserItems.size() > 0) {
                buffer.append(';');
                ListIterator i = this.mUserItems.listIterator();
                while (i.hasNext()) {
                    buffer.append(((ResourceUserItem)i.next()).toString());
                    if (!i.hasNext()) continue;
                    buffer.append(',');
                }
            }
        }
        buffer.append(']');
        return buffer.toString();
    }
}

