/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.threads;

import com.raplix.util.ObjectUtil;
import com.raplix.util.threads.Resource;
import com.raplix.util.threads.ResourceID;
import com.raplix.util.threads.ResourceManager;
import com.raplix.util.threads.ResourceUser;

class ResourceUserItem {
    private ResourceUser mUser;
    private Object mItem;
    private int mLevel;

    public ResourceUserItem(ResourceManager manager, ResourceID ID2, Resource resource, ResourceUser user) throws Exception {
        this.mUser = user;
        this.mLevel = 1;
        this.mItem = resource.acquire();
        this.getUser().acquired(manager, ID2, this.getItem());
    }

    public ResourceUser getUser() {
        return this.mUser;
    }

    public Object getItem() {
        return this.mItem;
    }

    public boolean matchesUser(ResourceUser user) {
        return this.mUser.equals(user);
    }

    public boolean matchesItem(Object item) {
        return ObjectUtil.equals(this.mItem, item);
    }

    public int getLevel() {
        return this.mLevel;
    }

    public void setLevel(int level) {
        this.mLevel = level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(ResourceManager manager, ResourceID ID2, Resource resource) throws Exception {
        try {
            resource.release(this.getItem());
        }
        finally {
            this.getUser().released(manager, ID2, this.getItem());
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('(');
        buffer.append(this.getUser());
        buffer.append(',');
        buffer.append(this.getItem());
        buffer.append(',');
        buffer.append(this.getLevel());
        buffer.append(')');
        return buffer.toString();
    }
}

