/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.threads;

import com.raplix.util.string.StringUtil;
import com.raplix.util.threads.PackageInfo;
import com.raplix.util.threads.Resource;
import com.raplix.util.threads.ResourceID;
import com.raplix.util.threads.ResourceOwner;
import com.raplix.util.threads.ResourceUser;
import com.raplix.util.threads.ResourceWrapper;
import java.util.Enumeration;
import java.util.Hashtable;

public class ResourceManager {
    private static final String EMPTY_MANAGER = "<Manager is empty>";
    private static long mNextNewID;
    private Hashtable mWrappers = new Hashtable();

    private ResourceWrapper getWrapper(ResourceID ID2) {
        ResourceWrapper w = (ResourceWrapper)this.mWrappers.get(ID2);
        if (w != null) {
            return w;
        }
        PackageInfo.throwUnknownResource(ID2);
        return null;
    }

    public static synchronized ResourceID generateResourceID() {
        return new ResourceID("R" + mNextNewID++);
    }

    public boolean hasResource(ResourceID ID2) {
        return this.mWrappers.get(ID2) != null;
    }

    public Resource getResource(ResourceID ID2) {
        return this.getWrapper(ID2).getResource();
    }

    public void register(ResourceID ID2, Resource resource, ResourceOwner owner) {
        ResourceWrapper w = new ResourceWrapper(resource, owner);
        w.register(this, ID2);
        this.mWrappers.put(ID2, w);
    }

    public ResourceID register(Resource resource, ResourceOwner owner) {
        ResourceID ID2 = ResourceManager.generateResourceID();
        this.register(ID2, resource, owner);
        return ID2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(ResourceID ID2) throws Exception {
        Hashtable hashtable = this.mWrappers;
        synchronized (hashtable) {
            ResourceWrapper w = this.getWrapper(ID2);
            try {
                w.unregister(this, ID2);
            }
            finally {
                this.mWrappers.remove(ID2);
            }
        }
    }

    public Object acquire(ResourceID ID2, ResourceUser user) throws Exception {
        return this.getWrapper(ID2).acquire(this, ID2, user);
    }

    public Object acquireNested(ResourceID ID2, ResourceUser user, Object item) throws Exception {
        return this.getWrapper(ID2).acquireNested(this, ID2, user, item);
    }

    public Object acquireNested(ResourceID ID2, ResourceUser user) throws Exception {
        return this.getWrapper(ID2).acquireNested(this, ID2, user);
    }

    public void release(ResourceID ID2, ResourceUser user, Object item) throws Exception {
        this.getWrapper(ID2).release(this, ID2, user, item);
    }

    public void releaseNested(ResourceID ID2, ResourceUser user, Object item) throws Exception {
        this.getWrapper(ID2).releaseNested(this, ID2, user, item);
    }

    public void release(ResourceID ID2, ResourceUser user) throws Exception {
        this.getWrapper(ID2).release(this, ID2, user);
    }

    public void releaseNested(ResourceID ID2, ResourceUser user) throws Exception {
        this.getWrapper(ID2).releaseNested(this, ID2, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(ResourceUser user) throws Exception {
        Hashtable hashtable = this.mWrappers;
        synchronized (hashtable) {
            Enumeration e = this.mWrappers.keys();
            while (e.hasMoreElements()) {
                ResourceID ID2 = (ResourceID)e.nextElement();
                ((ResourceWrapper)this.mWrappers.get(ID2)).release(this, ID2, user);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Hashtable hashtable = this.mWrappers;
        synchronized (hashtable) {
            if (this.mWrappers.size() > 0) {
                Enumeration e = this.mWrappers.keys();
                while (e.hasMoreElements()) {
                    ResourceID ID2 = (ResourceID)e.nextElement();
                    buffer.append(ID2);
                    buffer.append(':');
                    buffer.append(((ResourceWrapper)this.mWrappers.get(ID2)).toString());
                    if (!e.hasMoreElements()) continue;
                    buffer.append(StringUtil.LINE_SEPARATOR);
                }
            } else {
                buffer.append(EMPTY_MANAGER);
            }
        }
        return buffer.toString();
    }
}

