/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.threads;

import com.raplix.util.locks.DeadlockException;
import com.raplix.util.locks.LockableBase;
import com.raplix.util.threads.DeadlockDetector;
import com.raplix.util.threads.IdleDetector;
import com.raplix.util.threads.Resource;

public abstract class Queue
extends LockableBase
implements Resource {
    private String mName;
    private int mSerial;
    private int mMaxCount;
    private int mCount;
    private DeadlockDetector mDetector;

    protected Queue(DeadlockDetector detector, String name) {
        this.mName = name;
        this.mMaxCount = 1;
        this.mDetector = detector;
    }

    protected Queue(int maxCount, String name) {
        this.mName = name;
        this.mMaxCount = maxCount;
        this.mDetector = new IdleDetector();
    }

    protected abstract void add(Ticket var1);

    protected abstract void remove(Ticket var1);

    protected abstract boolean peek(Ticket var1, int var2);

    public synchronized Object acquire() throws DeadlockException, InterruptedException {
        this.mDetector.enqueued(this);
        Ticket ticket = new Ticket(this.mSerial++);
        this.add(ticket);
        while (true) {
            if (this.mCount < this.mMaxCount && this.peek(ticket, this.mMaxCount - this.mCount)) {
                this.remove(ticket);
                this.mDetector.dequeued(this);
                ++this.mCount;
                break;
            }
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                this.remove(ticket);
                this.mDetector.dequeued(this);
                throw ex;
            }
        }
        this.mDetector.acquired(this);
        return ticket.getNumber();
    }

    public synchronized void release(Object item) {
        this.mDetector.released(this);
        --this.mCount;
        this.notifyAll();
    }

    public String getName() {
        return this.mName;
    }

    public String toString() {
        return this.getName() == null ? super.toString() : this.getName();
    }

    static class Ticket {
        private Integer mNumber;
        private Thread mCreator;
        private long mTimeCreated;

        Ticket(int number) {
            this.mNumber = new Integer(number);
            this.mCreator = Thread.currentThread();
            this.mTimeCreated = System.currentTimeMillis();
        }

        Integer getNumber() {
            return this.mNumber;
        }

        Thread getCreator() {
            return this.mCreator;
        }

        long getTimeCreated() {
            return this.mTimeCreated;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append('(');
            buffer.append(this.getNumber());
            buffer.append(',');
            buffer.append(this.getCreator().getName());
            buffer.append(',');
            buffer.append(this.getTimeCreated());
            buffer.append(')');
            return buffer.toString();
        }
    }
}

