/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.threads;

import com.raplix.util.threads.DeadlockDetector;
import com.raplix.util.threads.PriorityMap;
import com.raplix.util.threads.Queue;
import com.raplix.util.threads.ThreadQueue;

public class PriorityQueue
extends Queue {
    private ThreadQueue mQueue;

    public PriorityQueue(DeadlockDetector detector, String name) {
        super(detector, name);
        this.mQueue = new ThreadQueue();
    }

    public PriorityQueue(DeadlockDetector detector, PriorityMap map, String name) {
        super(detector, name);
        this.mQueue = new ThreadQueue(map);
    }

    public PriorityQueue(int maxCount, String name) {
        super(maxCount, name);
        this.mQueue = new ThreadQueue();
    }

    public PriorityQueue(int maxCount, PriorityMap map, String name) {
        super(maxCount, name);
        this.mQueue = new ThreadQueue(map);
    }

    protected void add(Queue.Ticket ticket) {
        this.mQueue.add(ticket.getCreator(), ticket);
    }

    protected void remove(Queue.Ticket ticket) {
        this.mQueue.remove(ticket);
    }

    protected boolean peek(Queue.Ticket ticket, int count) {
        return this.mQueue.peek(ticket, count);
    }

    public String toString() {
        return super.toString() + ":" + this.mQueue.toString();
    }
}

