/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.threads;

import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.threads.PoolItem;
import com.raplix.util.threads.PoolItemCreator;
import com.raplix.util.threads.Resource;
import java.util.Stack;

public class Pool
implements Resource {
    private PoolItemCreator mCreator;
    private Stack mItems = new Stack();
    private int mMaxCount;
    private int mCount;

    public Pool(PoolItemCreator creator, int maxCount) {
        this.mCreator = creator;
        this.mMaxCount = maxCount;
    }

    public Pool(PoolItem[] items) {
        CollectionUtil.map(items, this.mItems);
        this.mMaxCount = this.mItems.size();
    }

    public synchronized Object acquire() throws Exception {
        while (true) {
            if (this.mCount < this.mMaxCount) {
                ++this.mCount;
                if (this.mItems.size() > 0) {
                    return (PoolItem)this.mItems.pop();
                }
                try {
                    return this.mCreator.create();
                }
                catch (Exception ex) {
                    --this.mCount;
                    throw ex;
                }
            }
            this.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release(Object item) throws Exception {
        block3: {
            boolean success = false;
            try {
                ((PoolItem)item).reset();
                success = true;
                Object var4_3 = null;
                if (!success) break block3;
                this.mItems.push(item);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (success) {
                    this.mItems.push(item);
                }
                this.notify();
                --this.mCount;
                throw throwable;
            }
        }
        this.notify();
        --this.mCount;
        {
        }
    }
}

