/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.threads;

import com.raplix.util.message.MessageManager;
import com.raplix.util.threads.ResourceID;
import com.raplix.util.threads.ThreadAbortedException;

public final class PackageInfo {
    public static final String NAME = PackageInfo.class.getPackage().getName();
    public static final String MSG_PREFIX = "util.threads";
    public static final String ERROR_ABNORMAL_END = "util.threads.ERROR_ABNORMAL_END";
    public static final String ERROR_NO_RELEASE = "util.threads.ERROR_NO_RELEASE";
    public static final String EX_UNKNOWN_RESOURCE = "util.threads.EX_UNKNOWN_RESOURCE";
    public static final String EX_ABORT_REQUESTED = "util.threads.EX_ABORT_REQUESTED";
    public static final String EX_BAD_NESTING = "util.threads.EX_BAD_NESTING";

    private PackageInfo() {
    }

    public static String createAbnormalEnd() {
        return MessageManager.messageAsString(ERROR_ABNORMAL_END);
    }

    public static String createNoRelease() {
        return MessageManager.messageAsString(ERROR_NO_RELEASE);
    }

    public static void throwUnknownResource(ResourceID ID2) {
        throw new IllegalArgumentException(MessageManager.messageAsString(EX_UNKNOWN_RESOURCE, new Object[]{ID2.toString()}));
    }

    public static void throwAbortRequested() throws ThreadAbortedException {
        throw new ThreadAbortedException(MessageManager.messageAsString(EX_ABORT_REQUESTED, new Object[]{Thread.currentThread().getName()}));
    }

    public static void throwBadNesting(Thread thread) {
        throw new IllegalStateException(MessageManager.messageAsString(EX_BAD_NESTING, new Object[]{thread.getName()}));
    }
}

