/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.threads;

import com.raplix.util.logger.Logger;
import com.raplix.util.string.StringUtil;
import com.raplix.util.threads.Aborter;
import com.raplix.util.threads.PackageInfo;
import com.raplix.util.threads.Resource;
import com.raplix.util.threads.ResourceID;
import com.raplix.util.threads.ResourceManager;
import com.raplix.util.threads.ResourceOwner;
import com.raplix.util.threads.ResourceUser;
import com.raplix.util.threads.Suspender;
import com.raplix.util.threads.ThreadAbortedException;
import java.util.LinkedList;
import java.util.ListIterator;

public class Context
implements ResourceOwner,
ResourceUser {
    public static final int INHERIT_PRIORITY = -2;
    private int mQueuePriority = -1;
    private String mName;
    private Context mParent;
    private Suspender mSuspender = new Suspender();
    private Aborter mAborter = new Aborter();
    private ResourceManager mManager = new ResourceManager();
    private LinkedList mRunningChildren = new LinkedList();

    protected Context(String name, Context parent) {
        this.mParent = parent;
        this.mName = name;
    }

    public Context(String name) {
        this(name, null);
    }

    private ResourceManager findManager(ResourceID ID2) {
        for (Context ctx = this; ctx != null; ctx = ctx.getParent()) {
            ResourceManager m = ctx.getManager();
            if (!m.hasResource(ID2)) continue;
            return m;
        }
        PackageInfo.throwUnknownResource(ID2);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFlowChild(Context child) {
        LinkedList linkedList = this.mRunningChildren;
        synchronized (linkedList) {
            this.mRunningChildren.add(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFlowChild(Context child) {
        LinkedList linkedList = this.mRunningChildren;
        synchronized (linkedList) {
            this.mRunningChildren.remove(child);
        }
    }

    protected void testSuspend() throws InterruptedException {
        for (Context ctx = this; ctx != null; ctx = ctx.getParent()) {
            ctx.mSuspender.test();
        }
    }

    protected void testAbort() throws ThreadAbortedException {
        for (Context ctx = this; ctx != null; ctx = ctx.getParent()) {
            ctx.mAborter.test();
        }
    }

    public String getName() {
        return this.mName;
    }

    public Context getParent() {
        return this.mParent;
    }

    public ResourceManager getManager() {
        return this.mManager;
    }

    public void suspend() {
        this.mSuspender.suspend();
    }

    public void resume() {
        this.mSuspender.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        this.mAborter.abort();
        this.resume();
        LinkedList linkedList = this.mRunningChildren;
        synchronized (linkedList) {
            ListIterator i = this.mRunningChildren.listIterator();
            while (i.hasNext()) {
                ((Context)i.next()).abort();
            }
        }
    }

    public Resource getResource(ResourceID ID2) {
        return this.findManager(ID2).getResource(ID2);
    }

    public void register(ResourceID ID2, Resource resource) {
        this.getManager().register(ID2, resource, this);
    }

    public ResourceID register(Resource resource) {
        return this.getManager().register(resource, this);
    }

    public void unregister(ResourceID ID2) throws Exception {
        this.findManager(ID2).unregister(ID2);
    }

    public Object acquire(ResourceID ID2) throws Exception {
        return this.findManager(ID2).acquire(ID2, this);
    }

    public Object acquireNested(ResourceID ID2, Object item) throws Exception {
        return this.findManager(ID2).acquireNested(ID2, this, item);
    }

    public Object acquireNested(ResourceID ID2) throws Exception {
        return this.findManager(ID2).acquireNested(ID2, this);
    }

    public void release(ResourceID ID2, Object item) throws Exception {
        this.findManager(ID2).release(ID2, this, item);
    }

    public void releaseNested(ResourceID ID2, Object item) throws Exception {
        this.findManager(ID2).releaseNested(ID2, this, item);
    }

    public void release(ResourceID ID2) throws Exception {
        this.findManager(ID2).release(ID2, this);
    }

    public void releaseNested(ResourceID ID2) throws Exception {
        this.findManager(ID2).releaseNested(ID2, this);
    }

    public void release() throws Exception {
        for (Context ctx = this; ctx != null; ctx = ctx.getParent()) {
            ctx.getManager().release(this);
        }
    }

    public void setStaticQueuePriority(int queuePriority) {
        this.mQueuePriority = queuePriority;
    }

    public int getStaticQueuePriority() {
        return this.mQueuePriority;
    }

    public int getQueuePriority() {
        for (Context ctx = this; ctx != null; ctx = ctx.getParent()) {
            int p = ctx.getStaticQueuePriority();
            if (p == -2) continue;
            return p;
        }
        return -1;
    }

    public void acquired(ResourceManager manager, ResourceID ID2, Object item) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Acquired: name '" + this.getName() + "'; ID '" + ID2 + "'; item '" + item + "'", this);
        }
    }

    public void released(ResourceManager manager, ResourceID ID2, Object item) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Released: name '" + this.getName() + "'; ID '" + ID2 + "'; item '" + item + "'", this);
        }
    }

    public void registered(ResourceManager manager, ResourceID ID2) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Registered: name '" + this.getName() + "'; ID '" + ID2 + "'", this);
        }
    }

    public void unregistered(ResourceManager manager, ResourceID ID2) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Unregistered: name '" + this.getName() + "'; ID '" + ID2 + "'", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Name: ");
        StringBuffer fullName = new StringBuffer();
        Context ctx = this;
        while (ctx != null) {
            fullName.insert(0, ctx.getName());
            if ((ctx = ctx.getParent()) == null) continue;
            fullName.insert(0, ':');
        }
        buffer.append(fullName);
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append("Children: ");
        LinkedList linkedList = this.mRunningChildren;
        synchronized (linkedList) {
            ListIterator i = this.mRunningChildren.listIterator();
            while (i.hasNext()) {
                buffer.append(((Context)i.next()).getName());
                if (!i.hasNext()) continue;
                buffer.append(',');
            }
        }
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append("Resource manager:");
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append(this.getManager());
        return buffer.toString();
    }
}

