/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.threads;

import com.raplix.util.locks.DeadlockException;
import com.raplix.util.locks.LockManager;
import com.raplix.util.threads.ContextThread;
import com.raplix.util.threads.DeadlockDetector;
import com.raplix.util.threads.Queue;
import com.raplix.util.threads.QueueLocker;
import com.raplix.util.threads.RunnableContext;

public class ActiveDetector
implements DeadlockDetector,
RunnableContext.EventListener {
    private LockManager mManager = new LockManager();
    private ThreadLocal mLockers = new ThreadLocal();

    private QueueLocker getLocker() {
        QueueLocker l = (QueueLocker)this.mLockers.get();
        if (l == null) {
            Thread t = Thread.currentThread();
            l = new QueueLocker(t);
            if (t instanceof ContextThread) {
                ((ContextThread)t).getContext().addListener(this);
            }
            this.mLockers.set(l);
        }
        return l;
    }

    public synchronized void ended(RunnableContext context) {
        this.getLocker().destroy();
    }

    public synchronized void acquired(Queue queue) {
        this.mManager.acquired(this.getLocker(), queue);
    }

    public synchronized void released(Queue queue) {
        this.mManager.released(queue);
    }

    public synchronized void enqueued(Queue queue) throws DeadlockException {
        this.mManager.enqueued(this.getLocker(), queue);
    }

    public synchronized void dequeued(Queue queue) {
        this.mManager.dequeued(this.getLocker());
    }

    public synchronized boolean isEmpty() {
        return this.mManager.isEmpty();
    }
}

