/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.threadpool;

import com.raplix.util.logger.Logger;
import com.raplix.util.threadpool.NoMoreThreads;
import com.raplix.util.threads.SafeThread;
import java.util.LinkedList;

public class ThreadPool {
    private ThreadGroup thg;
    private int min;
    private int max;
    public static final int DEFAULT_MIN = 10;
    public static final int DEFAULT_MAX = 100;
    private int threadCount = 1;
    protected LinkedList freePool = new LinkedList();
    protected LinkedList usedPool = new LinkedList();
    private static int poolCount = 0;

    private synchronized int poolId() {
        return ++poolCount;
    }

    public ThreadPool(String name, int min, int max) {
        this.thg = new ThreadGroup("ROX:ThrPool:" + this.poolId() + ":" + name);
        this.min = min;
        this.max = max;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("New Threadpool created:" + name, this);
        }
    }

    public ThreadPool(String name) {
        this(name, 10, 100);
    }

    public synchronized void start(Runnable task) throws NoMoreThreads {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Starting task:" + task + ":pool:" + this, this);
        }
        WorkerThread wt = null;
        if (this.freePool.isEmpty()) {
            if (this.usedPool.size() < this.max) {
                wt = new WorkerThread(this.thg, this.threadCount++);
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Created a new WorkerThread: " + this.threadCount + ", adding to usedPool and starting", this);
                }
                this.usedPool.add(wt);
                wt.assignTask(task);
                wt.start();
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Started new thread:" + wt + ":pool:" + this, this);
                }
            } else {
                this.handleFullFreeThreadPool(task);
            }
        } else {
            wt = (WorkerThread)this.freePool.removeFirst();
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Had free threads, removed " + wt.getName() + " and adding to usedPool and starting", this);
            }
            this.usedPool.add(wt);
            wt.assignTask(task);
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Using Thread:" + wt + ":pool:" + this, this);
            }
        }
    }

    protected synchronized void free(WorkerThread wt) {
        if (wt.isAlive()) {
            this.usedPool.remove(wt);
            this.freePool.add(wt);
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Removed thread from usedPool, added to freePool: " + wt.getName(), this);
            }
        } else {
            this.usedPool.remove(wt);
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Removed dead thread from usedPool: " + wt.getName(), this);
            }
        }
    }

    private synchronized void remove(WorkerThread wt) {
        this.usedPool.remove(wt);
        this.freePool.remove(wt);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Removed thread: " + wt.getName() + " from both pools", this);
        }
    }

    protected void handleFullFreeThreadPool(Runnable task) throws NoMoreThreads {
        throw new NoMoreThreads("Maximum Thread limit reached: " + this.max);
    }

    public String toString() {
        return this.getClass().getName() + ":Pool:" + this.thg + ":min:" + this.min + ":max:" + this.max + ":freePool:" + this.freePool.size() + ":usedPool:" + this.usedPool.size();
    }

    protected class WorkerThread
    extends SafeThread {
        Runnable currentTask;

        WorkerThread(ThreadGroup tGroup, int number) {
            super(tGroup, tGroup.getName() + "-Worker-" + number);
            this.currentTask = null;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (true) {
                    if (this.currentTask != null) {
                        block14: {
                            try {
                                if (Logger.isDebugEnabled(this)) {
                                    Logger.debug("Starting working:" + this, this);
                                }
                                this.currentTask.run();
                            }
                            catch (Throwable e) {
                                if (!Logger.isErrorEnabled(this)) break block14;
                                Logger.error("Unexpected Exception in worker thread:" + this, e, this);
                            }
                        }
                        if (Logger.isDebugEnabled(this)) {
                            Logger.debug("Done working:" + this, this);
                        }
                        this.currentTask = null;
                    }
                    try {
                        ThreadPool.this.free(this);
                        WorkerThread e = this;
                        synchronized (e) {
                            if (this.currentTask == null) {
                                this.wait();
                            }
                            continue;
                        }
                    }
                    catch (InterruptedException ie) {
                        if (!Logger.isErrorEnabled(this)) continue;
                        Logger.error("Unexpected interruption in WorkerThread.run()", ie, this);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                ThreadPool.this.remove(this);
                throw throwable;
            }
        }

        synchronized void assignTask(Runnable task) {
            this.currentTask = task;
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("assignTask notifies to start running", this);
            }
            this.notify();
        }

        public String toString() {
            return "WorkerThread:" + this.getName() + ":Task:" + this.currentTask;
        }
    }
}

