/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.table;

import com.raplix.util.table.Column;
import java.io.PrintWriter;
import java.util.Enumeration;

public class Table {
    private static final String BAR = "|";
    private static final String EMPTY_TABLE = "<Table is empty>";
    private static final int LINES_BETWEEN_TITLES = 24;
    private boolean mEmpty = true;
    private String mPrefix;
    private PrintWriter mWriter;
    private Column[] mColumns;
    private int mLines;

    public Table(PrintWriter writer, Column[] columns, String prefix) {
        this.mWriter = writer;
        this.mColumns = columns;
        this.mLines = 24;
        this.mPrefix = prefix;
    }

    public Table(PrintWriter writer, Column[] columns) {
        this(writer, columns, "");
    }

    private void newLine() {
        this.mWriter.println();
        ++this.mLines;
        this.mEmpty = false;
    }

    private void printDashes() {
        this.mWriter.print(this.mPrefix);
        this.mWriter.print(BAR);
        for (int i = 0; i < this.mColumns.length; ++i) {
            this.mColumns[i].printDashes(this.mWriter);
            this.mWriter.print(BAR);
        }
        this.newLine();
    }

    private void printTitles() {
        this.printDashes();
        this.mWriter.print(this.mPrefix);
        this.mWriter.print(BAR);
        for (int i = 0; i < this.mColumns.length; ++i) {
            this.mColumns[i].printTitle(this.mWriter);
            this.mWriter.print(BAR);
        }
        this.newLine();
        this.printDashes();
    }

    public void printRow(Enumeration data) {
        if (this.mLines >= 24) {
            this.mLines = 0;
            this.printTitles();
        }
        this.mWriter.print(this.mPrefix);
        this.mWriter.print(BAR);
        for (int i = 0; data.hasMoreElements() && i < this.mColumns.length; ++i) {
            this.mColumns[i].print(this.mWriter, (String)data.nextElement());
            this.mWriter.print(BAR);
        }
        this.newLine();
    }

    public void endPrinting() {
        if (this.mEmpty) {
            this.mWriter.print(this.mPrefix);
            this.mWriter.print(EMPTY_TABLE);
            this.newLine();
        } else {
            this.printDashes();
        }
    }
}

