/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.string;

import com.raplix.util.string.Escape;

public class UnicodeEscape
implements Escape {
    public static final int MAX_ISO_8859_1 = 255;
    private static final String UNICODE_ESCAPE_PREFIX = "\\u";
    private static final UnicodeEscape ESCAPE = new UnicodeEscape();

    public String escape(String str) {
        return this.escape(str, 256, 65535);
    }

    public String escapeAllCharacters(String str) {
        return this.escape(str, 0, 65535);
    }

    public String escape(String str, int low, int high) {
        if (str == null) {
            return null;
        }
        StringBuffer escaped = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch < low || ch > high) {
                escaped.append(ch);
                continue;
            }
            escaped.append(UNICODE_ESCAPE_PREFIX);
            String hex = Integer.toHexString(str.charAt(i));
            int numToPad = 4 - hex.length();
            for (int j = 0; j < numToPad; ++j) {
                escaped.append("0");
            }
            escaped.append(hex);
        }
        return escaped.toString();
    }

    public String unescape(String str) {
        return this.unescape(str, 0, 65535);
    }

    public String unescape(String str, int low, int high) {
        if (str == null) {
            return null;
        }
        StringBuffer unescaped = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            int code;
            char c1 = str.charAt(i);
            if (c1 != UNICODE_ESCAPE_PREFIX.charAt(0)) {
                unescaped.append(c1);
                continue;
            }
            if (i + 1 >= str.length()) {
                unescaped.append(c1);
                continue;
            }
            char c2 = str.charAt(i + 1);
            if (c2 != UNICODE_ESCAPE_PREFIX.charAt(1)) {
                unescaped.append(c1);
                continue;
            }
            if (i + 6 > str.length()) {
                unescaped.append(c1);
                continue;
            }
            try {
                code = Integer.parseInt(str.substring(i + 2, i + 6), 16);
            }
            catch (NumberFormatException ex) {
                unescaped.append(c1);
                continue;
            }
            char c3 = (char)code;
            if (c3 >= low && c3 <= high) {
                unescaped.append(c3);
                i += 5;
                continue;
            }
            unescaped.append(c1);
        }
        return unescaped.toString();
    }

    public static UnicodeEscape getGlobalInstance() {
        return ESCAPE;
    }
}

