/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.string;

import [Ljava.lang.String;;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.string.PackageInfo;
import com.raplix.util.string.StringEscapedTokenizer;
import java.util.Hashtable;
import java.util.Vector;

public final class StringUtil {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String UNTAGGED_KEY = "untagged";

    private StringUtil() {
    }

    public static boolean isEmpty(String str) {
        if (str == null) {
            return true;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String normalizeEmpty(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public static String repeat(String str, int count) {
        StringBuffer buffer = new StringBuffer(count * str.length());
        for (int i = 0; i < count; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    public static String extend(String str, String separator, String extension) {
        if (StringUtil.isEmpty(str)) {
            return extension;
        }
        return str + separator + extension;
    }

    public static void extend(StringBuffer buffer, String separator, String extension) {
        if (buffer.length() > 0) {
            buffer.append(separator);
        }
        buffer.append(extension);
    }

    public static String[] split(String str, char delimiter) {
        int index = str.lastIndexOf(delimiter);
        if (index == -1) {
            return new String[]{"", str};
        }
        return new String[]{str.substring(0, index), str.substring(index + 1)};
    }

    public static String[] split(String str, String delimiters, String escapes) {
        StringEscapedTokenizer tokenizer = new StringEscapedTokenizer(str, delimiters, escapes);
        Vector<String> dst = new Vector<String>();
        while (tokenizer.hasMoreTokens()) {
            dst.addElement(tokenizer.nextToken());
        }
        return (String[])CollectionUtil.mapClass(dst, String.class);
    }

    public static Hashtable parse(String[] args, int skipCount, Hashtable argCounts) {
        int expected;
        Hashtable<String, Object> h = new Hashtable<String, Object>();
        for (int nextArg = skipCount; nextArg < args.length; nextArg += expected) {
            int actual;
            String tag = args[nextArg];
            Integer count = (Integer)argCounts.get(tag);
            if (count == null) {
                h.put(UNTAGGED_KEY, CollectionUtil.sliceClass(args, String;.class, nextArg, CollectionUtil.LAST_INDEX));
                return h;
            }
            expected = count;
            if ((actual = args.length - ++nextArg) < expected) {
                throw PackageInfo.createBadArgument(tag, expected, actual);
            }
            h.put(tag, CollectionUtil.sliceClass(args, array$Ljava$lang$String == null ? StringUtil.class$("[Ljava.lang.String;") : array$Ljava$lang$String, nextArg, nextArg + expected));
        }
        h.put(UNTAGGED_KEY, new String[0]);
        return h;
    }

    public static int compareDictionary(String s1, String s2) {
        int c = s1.compareToIgnoreCase(s2);
        if (c != 0) {
            return c;
        }
        return s1.compareTo(s2);
    }
}

