/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.string;

public class StringEscapedTokenizer {
    private String mStr;
    private String mDelimiters;
    private String mEscapes;
    private int mIndex;
    private boolean mLastIsDelimiter;

    public StringEscapedTokenizer(String str, String delimiters, String escapes) {
        this.mStr = str;
        this.mDelimiters = delimiters;
        this.mEscapes = escapes;
        this.mIndex = 0;
    }

    public String nextToken() {
        if (this.mIndex == this.mStr.length()) {
            if (this.mLastIsDelimiter) {
                this.mLastIsDelimiter = false;
                return "";
            }
            return null;
        }
        this.mLastIsDelimiter = false;
        StringBuffer buffer = new StringBuffer();
        while (this.mIndex < this.mStr.length()) {
            char c = this.mStr.charAt(this.mIndex);
            if (this.mDelimiters.indexOf(c) >= 0) {
                this.mLastIsDelimiter = true;
                ++this.mIndex;
                return buffer.toString();
            }
            if (this.mEscapes.indexOf(c) >= 0) {
                ++this.mIndex;
                if (this.mIndex == this.mStr.length()) {
                    buffer.append(c);
                    return buffer.toString();
                }
                c = this.mStr.charAt(this.mIndex);
            }
            buffer.append(c);
            ++this.mIndex;
        }
        return buffer.toString();
    }

    public boolean hasMoreTokens() {
        return this.mIndex < this.mStr.length() || this.mLastIsDelimiter;
    }
}

