/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.string;

import java.util.Enumeration;
import java.util.Hashtable;

public final class Replace {
    private Replace() {
    }

    public static String replace(String str, char ch, String rep, int start, int end) {
        StringBuffer buffer = new StringBuffer(str.length());
        buffer.append(str.substring(0, start));
        for (int i = start; i < end; ++i) {
            char c = str.charAt(i);
            if (c == ch) {
                buffer.append(rep);
                continue;
            }
            buffer.append(c);
        }
        buffer.append(str.substring(end));
        return buffer.toString();
    }

    public static String replace(String str, char ch, String rep) {
        return Replace.replace(str, ch, rep, 0, str.length());
    }

    public static String replace(String str, String search, String rep, int start, int end) {
        StringBuffer buffer = new StringBuffer(str.substring(0, start));
        while (true) {
            int i = str.indexOf(search, start);
            int last = i + search.length();
            if (i == -1 || last > end) break;
            buffer.append(str.substring(start, i));
            buffer.append(rep);
            start = last;
        }
        buffer.append(str.substring(start));
        return buffer.toString();
    }

    public static String replace(String str, String search, String rep) {
        return Replace.replace(str, search, rep, 0, str.length());
    }

    public static String replace(String str, Hashtable map, int start, int end) {
        StringBuffer buffer = new StringBuffer(str.substring(0, start));
        while (true) {
            int last;
            int i;
            String search = null;
            String rep = null;
            for (i = start; i < end; ++i) {
                Enumeration e = map.keys();
                while (e.hasMoreElements()) {
                    search = (String)e.nextElement();
                    if (!str.startsWith(search, i)) continue;
                    rep = (String)map.get(search);
                    break;
                }
                if (rep != null) break;
            }
            if (i == end || (last = i + search.length()) > end) break;
            buffer.append(str.substring(start, i));
            buffer.append(rep);
            start = last;
        }
        buffer.append(str.substring(start));
        return buffer.toString();
    }

    public static String replace(String str, Hashtable map) {
        return Replace.replace(str, map, 0, str.length());
    }

    public static void replace(StringBuffer buf, String search, String rep, int start, int end) {
        int last = start;
        int diff = rep.length() - search.length();
        while (true) {
            int i = buf.indexOf(search, last);
            last = i + search.length();
            if (i == -1 || last > end) break;
            buf.replace(i, last, rep);
            last = i + rep.length();
            end += diff;
        }
    }
}

