/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.string;

import com.raplix.util.string.StringUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;

public class PasswordEscape {
    private static final int ILLEGAL_USAGE = 1;
    private static final int ENCODE_ERROR = 2;
    private static final String UTF8 = "UTF-8";

    private PasswordEscape() {
    }

    public static void main(String[] args) {
        PrintStream origStdout = System.out;
        PrintStream newStdout = new PrintStream(new ByteArrayOutputStream());
        System.setOut(newStdout);
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        if (args.length != 0) {
            System.exit(1);
        }
        try {
            origStdout.println(PasswordEscape.encodePassword(in.readLine()));
        }
        catch (IOException io) {
            System.err.println("Unable to encode password:" + io.getMessage());
            System.exit(2);
        }
    }

    public static String encodePassword(String plainPassword) throws IOException {
        if (!StringUtil.isEmpty(plainPassword)) {
            try {
                return new BigInteger(plainPassword.getBytes(UTF8)).toString(36);
            }
            catch (UnsupportedEncodingException e) {
                throw new IOException(e.getMessage());
            }
            catch (NumberFormatException ne) {
                throw new IOException(ne.getMessage());
            }
        }
        return plainPassword;
    }

    public static String decodePassword(String encodedPassword) throws IOException {
        if (!StringUtil.isEmpty(encodedPassword)) {
            try {
                return new String(new BigInteger(encodedPassword, 36).toByteArray(), UTF8);
            }
            catch (UnsupportedEncodingException e) {
                throw new IOException(e.getMessage());
            }
            catch (NumberFormatException ne) {
                throw new IOException(ne.getMessage());
            }
        }
        return encodedPassword;
    }
}

