/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.string;

import com.raplix.util.string.Escape;
import com.raplix.util.string.PackageInfo;

public class JavaEscape
implements Escape {
    private static final JavaEscape ESCAPE = new JavaEscape();

    public String escape(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\\') {
                buffer.append('\\');
                buffer.append('\\');
                continue;
            }
            if (c == '\b') {
                buffer.append('\\');
                buffer.append('b');
                continue;
            }
            if (c == '\t') {
                buffer.append('\\');
                buffer.append('t');
                continue;
            }
            if (c == '\n') {
                buffer.append('\\');
                buffer.append('n');
                continue;
            }
            if (c == '\f') {
                buffer.append('\\');
                buffer.append('f');
                continue;
            }
            if (c == '\r') {
                buffer.append('\\');
                buffer.append('r');
                continue;
            }
            if (Character.isISOControl(c)) {
                buffer.append('\\');
                buffer.append('u');
                String h = Integer.toHexString(c);
                for (int j = 4 - h.length(); j > 0; --j) {
                    buffer.append('0');
                }
                buffer.append(h);
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public String unescape(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(str.length());
        for (int i = 0; i < str.length(); ++i) {
            int code;
            char c = str.charAt(i);
            if (c != '\\') {
                buffer.append(c);
                continue;
            }
            if (++i >= str.length()) {
                throw PackageInfo.createBadJavaString(str, i);
            }
            c = str.charAt(i);
            if (c == '\\') {
                buffer.append('\\');
                continue;
            }
            if (c == 'b') {
                buffer.append('\b');
                continue;
            }
            if (c == 't') {
                buffer.append('\t');
                continue;
            }
            if (c == 'n') {
                buffer.append('\n');
                continue;
            }
            if (c == 'f') {
                buffer.append('\f');
                continue;
            }
            if (c == 'r') {
                buffer.append('\r');
                continue;
            }
            if (c != 'u') {
                throw PackageInfo.createBadJavaString(str, i);
            }
            if (++i + 4 > str.length()) {
                throw PackageInfo.createBadJavaString(str, i);
            }
            try {
                code = Integer.parseInt(str.substring(i, i + 4), 16);
            }
            catch (NumberFormatException ex) {
                throw PackageInfo.createBadJavaString(str, i);
            }
            c = (char)code;
            if (!Character.isISOControl(c)) {
                throw PackageInfo.createBadJavaString(str, i);
            }
            buffer.append(c);
            i += 3;
        }
        return buffer.toString();
    }

    public static JavaEscape getGlobalInstance() {
        return ESCAPE;
    }
}

