/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.string;

import com.raplix.util.string.Escape;
import com.raplix.util.string.PackageInfo;

public class EmacsEscape
implements Escape {
    private static final EmacsEscape ESCAPE = new EmacsEscape();
    public static final char BASE = '@';

    public String escape(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\\') {
                buffer.append('\\');
                buffer.append('\\');
                continue;
            }
            if (c >= '\u0000' && c <= '\u001f') {
                buffer.append('\\');
                buffer.append((char)(c + 64));
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public String unescape(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c != '\\') {
                buffer.append(c);
                continue;
            }
            if (++i >= str.length()) {
                throw PackageInfo.createBadEmacsString(str, i);
            }
            c = str.charAt(i);
            if (c == '\\') {
                buffer.append('\\');
                continue;
            }
            int code = c - 64;
            if (code < 0 || code >= 31) {
                throw PackageInfo.createBadEmacsString(str, i);
            }
            buffer.append((char)code);
        }
        return buffer.toString();
    }

    public static EmacsEscape getGlobalInstance() {
        return ESCAPE;
    }
}

