/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.string;

import com.raplix.util.string.Escape;
import com.raplix.util.string.PackageInfo;

public class DBEscape
implements Escape {
    private static final char MAX_CONTROL = '\u001f';
    private static final char MAX_PRINTABLE = '\u007f';
    private static final char ESCAPE_CHAR = '!';
    private static final DBEscape ESCAPE = new DBEscape();

    public String escape(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c <= '\u001f' && !Character.isWhitespace(c) || c > '\u007f' || c == '{' || c == '\\') {
                buffer.append('!');
                buffer.append('u');
                String h = Integer.toHexString(c);
                for (int j = 4 - h.length(); j > 0; --j) {
                    buffer.append('0');
                }
                buffer.append(h);
                continue;
            }
            if (c == '!') {
                buffer.append('!');
                buffer.append('!');
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public String unescape(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(str.length());
        for (int i = 0; i < str.length(); ++i) {
            int code;
            char c = str.charAt(i);
            if (c != '!') {
                buffer.append(c);
                continue;
            }
            if (++i >= str.length()) {
                throw PackageInfo.createBadDBString(str, i);
            }
            c = str.charAt(i);
            if (c == '!') {
                buffer.append('!');
                continue;
            }
            if (c != 'u') {
                throw PackageInfo.createBadDBString(str, i);
            }
            if (++i + 4 > str.length()) {
                throw PackageInfo.createBadDBString(str, i);
            }
            try {
                code = Integer.parseInt(str.substring(i, i + 4), 16);
            }
            catch (NumberFormatException ex) {
                throw PackageInfo.createBadDBString(str, i);
            }
            c = (char)code;
            buffer.append(c);
            i += 3;
        }
        return buffer.toString();
    }

    public static DBEscape getGlobalInstance() {
        return ESCAPE;
    }
}

