/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.string;

import com.raplix.util.ObjectUtil;

public class CaseString {
    private String mValue;
    private String mNormalizedValue;
    private boolean mUpcase;

    public CaseString(String value, boolean upcase) {
        this.mValue = value;
        this.mUpcase = upcase;
        this.mNormalizedValue = this.mValue == null ? null : (this.mUpcase ? this.mValue.toUpperCase() : this.mValue);
    }

    public String getValue() {
        return this.mValue;
    }

    public boolean getUpcase() {
        return this.mUpcase;
    }

    public String getNormalizedValue() {
        return this.mNormalizedValue;
    }

    public static CaseString[] toCaseArray(String[] array, boolean upcase) {
        if (array == null) {
            return null;
        }
        CaseString[] result = new CaseString[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = new CaseString(array[i], upcase);
        }
        return result;
    }

    public static String[] toStringArray(CaseString[] array) {
        if (array == null) {
            return null;
        }
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].getNormalizedValue();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        return ObjectUtil.equals(this.getNormalizedValue(), ((CaseString)o).getNormalizedValue());
    }

    public int hashCode() {
        return ObjectUtil.hashCode(this.getNormalizedValue());
    }

    public String toString() {
        return this.getValue();
    }
}

