/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.string;

import [Ljava.lang.String;;
import com.raplix.util.collections.CollectionUtil;
import java.util.Vector;

public final class CSVUtil {
    private CSVUtil() {
    }

    public static String compose(char qualifier, char separator, String[] values) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                buffer.append(separator);
            }
            buffer.append(qualifier);
            String v = values[i];
            for (int j = 0; j < v.length(); ++j) {
                char c = v.charAt(j);
                if (c == qualifier) {
                    buffer.append(qualifier);
                }
                buffer.append(c);
            }
            buffer.append(qualifier);
        }
        return buffer.toString();
    }

    public static String composeCSV(String[] values) {
        return CSVUtil.compose('\"', ',', values);
    }

    public static String composePSV(String[] values) {
        return CSVUtil.compose('\"', '|', values);
    }

    public static String[] split(char qualifier, char separator, String line) {
        StringBuffer buffer = new StringBuffer();
        Vector<String> v = new Vector<String>();
        boolean lastIsSeparator = false;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            lastIsSeparator = false;
            if (c != qualifier) {
                while (i < line.length()) {
                    c = line.charAt(i);
                    if (c == separator) {
                        lastIsSeparator = true;
                        break;
                    }
                    buffer.append(c);
                    ++i;
                }
            } else {
                ++i;
                while (i < line.length() && ((c = line.charAt(i)) != qualifier || ++i < line.length() && line.charAt(i) == qualifier)) {
                    buffer.append(c);
                    ++i;
                }
                while (i < line.length()) {
                    if (line.charAt(i) == separator) {
                        lastIsSeparator = true;
                        break;
                    }
                    ++i;
                }
            }
            v.addElement(buffer.toString());
            buffer = new StringBuffer();
        }
        if (lastIsSeparator) {
            v.addElement("");
        }
        return (String[])CollectionUtil.mapClass(v, String;.class);
    }

    public static String[] splitCSV(String line) {
        return CSVUtil.split('\"', ',', line);
    }

    public static String[] splitPSV(String line) {
        return CSVUtil.split('\"', '|', line);
    }
}

