/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.sql;

import com.raplix.util.sql.ColumnDefinition;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class StringColumnDefinition
extends ColumnDefinition {
    public StringColumnDefinition(String inColumnName, String inFieldName) {
        super(inColumnName, inFieldName);
    }

    public int getColumnType() {
        return 2;
    }

    public void setFieldFromRow(Field inField, Object inObject, ResultSet inResultSet) {
        try {
            if (inField.getType().isArray()) {
                String theArrayStr = inResultSet.getString(this.getColumnName());
                if (theArrayStr != null) {
                    StringTokenizer strTok = new StringTokenizer(theArrayStr, "{}\",");
                    int theArraySize = strTok.countTokens();
                    String[] theValue = new String[theArraySize];
                    for (int i = 0; i < theArraySize; ++i) {
                        String theToken;
                        theValue[i] = theToken = strTok.nextToken();
                    }
                    inField.set(inObject, theValue);
                } else {
                    inField.set(inObject, new String[0]);
                }
            } else {
                String theValue = inResultSet.getString(this.getColumnName());
                inField.set(inObject, theValue);
            }
        }
        catch (Exception e) {
            StringColumnDefinition.logError(2, "During setFieldFromRow for " + this.getColumnName(), e);
        }
    }

    public void setRowFromField(Field inField, Object inObject, Hashtable inValues) {
        try {
            if (inField.getType().isArray()) {
                Object theArray = inField.get(inObject);
                String theArrayStr = null;
                if (theArray != null) {
                    int arrLen = Array.getLength(theArray);
                    if (arrLen > 0) {
                        theArrayStr = "'{";
                    }
                    for (int i = 0; i < arrLen; ++i) {
                        String theVal = (String)Array.get(theArray, i);
                        theArrayStr = i > 0 ? theArrayStr + ",\"" + theVal + "\"" : theArrayStr + "\"" + theVal + "\"";
                    }
                    if (arrLen > 0) {
                        theArrayStr = theArrayStr + "}'";
                    }
                }
                if (theArrayStr != null) {
                    inValues.put(this.getColumnName(), theArrayStr);
                }
            } else {
                String theValue = (String)inField.get(inObject);
                if (theValue != null) {
                    inValues.put(this.getColumnName(), "'" + theValue + "'");
                } else {
                    inValues.put(this.getColumnName(), "null");
                }
            }
        }
        catch (Exception e) {
            StringColumnDefinition.logError(2, "During setRowFromField for " + this.getColumnName(), e);
        }
    }

    public void setPreparedStatementValue(Field inField, Object inObject, int inIndex, PreparedStatement inStatement) {
        try {
            String theValue = (String)inField.get(inObject);
            inStatement.setString(inIndex, theValue);
        }
        catch (Exception e) {
            StringColumnDefinition.logError(2, "During setPreparedStatementValue for " + this.getColumnName(), e);
        }
    }
}

