/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.sql;

import com.raplix.util.sql.Database;
import com.raplix.util.sql.SQLQuery;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class SQLUpdate
extends SQLQuery {
    protected String mTable;
    protected Vector mColumns = new Vector();
    protected Vector mValues = new Vector();
    protected Vector mWheres = null;

    public SQLUpdate(Database db, String table) throws SQLException {
        super(db);
        this.mTable = table;
    }

    public void addColumn(String column, String value) {
        this.mColumns.addElement(column);
        this.mValues.addElement(value);
    }

    public void addColumn(String column, int value) {
        this.mColumns.addElement(column);
        this.mValues.addElement(new Integer(value));
    }

    public void addColumn(String column, Object value) {
        if (value instanceof Integer) {
            this.addColumn(column, (Integer)value);
        } else {
            this.addColumn(column, value.toString());
        }
    }

    public void addWhere(String where) {
        if (this.mWheres == null) {
            this.mWheres = new Vector();
        }
        this.mWheres.addElement(where);
    }

    public ResultSet execute() throws SQLException {
        String q = this.generateQuery();
        this.mStatement.executeUpdate(q);
        return null;
    }

    public String generateWheres() {
        if (this.mWheres == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" WHERE");
        for (int i = 0; i < this.mWheres.size(); ++i) {
            sb.append(" ");
            sb.append(this.mWheres.elementAt(i).toString());
        }
        return sb.toString();
    }

    public String generateQuery() {
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE " + this.mTable + " SET ");
        for (int i = 0; i < this.mColumns.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.mColumns.elementAt(i));
            sb.append('=');
            Object o = this.mValues.elementAt(i);
            if (o instanceof Integer) {
                sb.append(o.toString());
                continue;
            }
            sb.append("'" + o.toString() + "'");
        }
        sb.append(this.generateWheres());
        return sb.toString();
    }
}

