/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.sql;

import com.raplix.util.sql.BlobColumnDefinition;
import com.raplix.util.sql.BooleanColumnDefinition;
import com.raplix.util.sql.ColumnDefinition;
import com.raplix.util.sql.DateColumnDefinition;
import com.raplix.util.sql.IntegerColumnDefinition;
import com.raplix.util.sql.LongColumnDefinition;
import com.raplix.util.sql.StringColumnDefinition;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SQLTableMap {
    protected static Hashtable sMapRegistrationTable = new Hashtable();
    protected Class mClass;
    protected String mTableName;
    protected Hashtable mMappings;
    protected Vector mKeys;
    protected Hashtable mDefaultInserts;
    protected Hashtable mReadOnlys;

    public SQLTableMap(Class inForClass, String inTableName) {
        this.mClass = inForClass;
        this.mTableName = inTableName;
        this.mMappings = new Hashtable();
        this.mKeys = new Vector();
        this.mDefaultInserts = new Hashtable();
        this.mReadOnlys = new Hashtable();
        sMapRegistrationTable.put(inForClass, this);
    }

    public Hashtable getMappings() {
        return this.mMappings;
    }

    public String getTableName() {
        return this.mTableName;
    }

    public Class getMappedClass() {
        return this.mClass;
    }

    public Vector getKeys() {
        return this.mKeys;
    }

    public boolean isDefaultInsert(String inColumnName) {
        return this.mDefaultInserts.get(inColumnName) != null;
    }

    public boolean isReadOnly(String inColumnName) {
        return this.mReadOnlys.get(inColumnName) != null;
    }

    public String getAccessorCode() {
        StringBuffer sb = new StringBuffer();
        Enumeration elems = this.mMappings.elements();
        sb.append("     //------------ Accessors\n");
        while (elems.hasMoreElements()) {
            ColumnDefinition cd = (ColumnDefinition)elems.nextElement();
            String varName = cd.getFieldName();
            String tag = varName.substring(1);
            String type = "ERROR";
            switch (cd.getColumnType()) {
                case 1: {
                    type = "int";
                    break;
                }
                case 6: {
                    type = "long";
                    break;
                }
                case 2: {
                    type = "String";
                    break;
                }
                case 3: {
                    type = "java.sql.Date";
                    break;
                }
                case 4: {
                    type = "boolean";
                    break;
                }
                case 5: {
                    type = "byte []";
                }
            }
            sb.append("\tpublic " + type + " get" + tag);
            sb.append("() {\n");
            sb.append("\t\treturn " + varName + ";\n\t}\n");
            sb.append("\tpublic void set" + tag);
            sb.append("(" + type + " inVal) {\n");
            sb.append("\t\t" + varName + " = inVal;\n\t}\n");
        }
        return sb.toString();
    }

    public ColumnDefinition getColumnForField(String inFieldName) {
        Enumeration e = this.mMappings.elements();
        while (e.hasMoreElements()) {
            ColumnDefinition cd = (ColumnDefinition)e.nextElement();
            if (!cd.getFieldName().equals(inFieldName)) continue;
            return cd;
        }
        return null;
    }

    public void declareKey(String inKey) {
        this.mKeys.addElement(inKey);
    }

    public void allowDefaultInsert(String inKey) {
        this.mDefaultInserts.put(inKey, "y");
    }

    public void declareReadOnly(String inKey) {
        this.mReadOnlys.put(inKey, "y");
    }

    public void declareColumn(String inColumnName, int inColumnType, String inFieldName) {
        switch (inColumnType) {
            case 6: {
                this.mMappings.put(inColumnName, new LongColumnDefinition(inColumnName, inFieldName));
                break;
            }
            case 1: {
                this.mMappings.put(inColumnName, new IntegerColumnDefinition(inColumnName, inFieldName));
                break;
            }
            case 2: {
                this.mMappings.put(inColumnName, new StringColumnDefinition(inColumnName, inFieldName));
                break;
            }
            case 3: {
                this.mMappings.put(inColumnName, new DateColumnDefinition(inColumnName, inFieldName));
                break;
            }
            case 4: {
                this.mMappings.put(inColumnName, new BooleanColumnDefinition(inColumnName, inFieldName));
                break;
            }
            case 5: {
                this.mMappings.put(inColumnName, new BlobColumnDefinition(inColumnName, inFieldName));
            }
        }
    }

    protected static SQLTableMap findObjectMap(Object inObj) throws SQLException {
        Class<?> myClass = inObj.getClass();
        SQLTableMap ret = (SQLTableMap)sMapRegistrationTable.get(myClass);
        if (ret == null) {
            throw new SQLException("Error: couldn't find object map for object of " + myClass + ".  Unable to use SQLObject methods.");
        }
        return ret;
    }
}

