/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.sql;

import com.raplix.util.sql.Database;
import com.raplix.util.sql.SQLQuery;
import java.sql.SQLException;
import java.util.Vector;

public class SQLSelect
extends SQLQuery {
    protected String mTable;
    protected String mOrder = null;
    protected Vector mOutputColumns = null;
    protected Vector mWheres = null;

    public SQLSelect(Database db, String table) throws SQLException {
        super(db);
        this.mTable = table;
    }

    public void addOutputColumn(String column) {
        if (this.mOutputColumns == null) {
            this.mOutputColumns = new Vector();
        }
        this.mOutputColumns.addElement(column);
    }

    public void addWhere(String where) {
        if (this.mWheres == null) {
            this.mWheres = new Vector();
        }
        this.mWheres.addElement(where);
    }

    public void orderBy(String order) {
        this.mOrder = order;
    }

    public String generateColumnsToSelect() {
        if (this.mOutputColumns == null) {
            return "*";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.mOutputColumns.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.mOutputColumns.elementAt(i).toString());
        }
        return sb.toString();
    }

    public String generateWheres() {
        if (this.mWheres == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" WHERE");
        for (int i = 0; i < this.mWheres.size(); ++i) {
            sb.append(" ");
            sb.append(this.mWheres.elementAt(i).toString());
        }
        return sb.toString();
    }

    public String generateQuery() {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ");
        sb.append(this.generateColumnsToSelect());
        sb.append(" FROM ");
        sb.append(this.mTable);
        sb.append(this.generateWheres());
        if (this.mOrder != null) {
            sb.append(" ORDER BY " + this.mOrder);
        }
        return sb.toString();
    }
}

