/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.sql;

import com.raplix.util.sql.ColumnDefinition;
import com.raplix.util.sql.Database;
import com.raplix.util.sql.SQLInsert;
import com.raplix.util.sql.SQLSelect;
import com.raplix.util.sql.SQLUpdate;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class SQLQuery {
    protected Database mDB = null;
    protected Connection mConn;
    protected Statement mStatement;
    protected boolean mOwnStatement = false;
    protected boolean mOwnConnection = false;
    protected boolean mClosed = false;

    protected SQLQuery(Database db) throws SQLException {
        this.mDB = db;
        int attempts = 0;
        while (true) {
            this.mConn = db.getConnection();
            if (this.mConn != null) break;
            if (++attempts == 10) {
                System.err.println("Couldn't get a database connection after 10 attemtps.");
                throw new SQLException("Couldn't get connection for SQLQuery.");
            }
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                ColumnDefinition.logError(1, "SQLQuery", ie);
                throw new SQLException("(Interrupted) Couldn't get connection for SQLQuery.");
            }
        }
        this.mStatement = this.mConn.createStatement();
        this.mOwnConnection = true;
        this.mOwnStatement = true;
    }

    public ResultSet execute() throws SQLException {
        String q = this.generateQuery();
        return this.mStatement.executeQuery(q);
    }

    public abstract String generateQuery();

    public void close() {
        if (this.mClosed) {
            return;
        }
        try {
            if (this.mOwnStatement) {
                this.mStatement.close();
            }
            if (this.mOwnConnection) {
                this.mDB.returnConnection(this.mConn);
            }
        }
        catch (SQLException sqle) {
            ColumnDefinition.logError(1, "SQLQuery", sqle);
        }
        this.mClosed = true;
    }

    public static String getTrimmedResultString(ResultSet rs, String column) {
        return SQLQuery.getTrimmedResultString(rs, column, "");
    }

    public static String getTrimmedResultString(ResultSet rs, String column, String defaultVal) {
        try {
            String s = rs.getString(column);
            if (s == null) {
                return defaultVal;
            }
            return s.trim();
        }
        catch (SQLException sqle) {
            ColumnDefinition.logError(1, "SQLQuery", sqle);
            return defaultVal;
        }
    }

    public static void insertOverExisting(Database db, String tableName, Object[] selectorColumns, Object[] selectorValues, Object[] newColumns, Object[] newValues) {
        SQLSelect q = null;
        SQLQuery ins = null;
        SQLQuery upd = null;
        try {
            int i;
            q = new SQLSelect(db, tableName);
            for (int i2 = 0; i2 < selectorColumns.length; ++i2) {
                boolean isStr = selectorValues[i2] instanceof String;
                String str = selectorColumns[i2] + "=" + (isStr ? "'" : "") + selectorValues[i2] + (isStr ? "'" : "");
                if (i2 > 0) {
                    q.addWhere("AND " + str);
                    continue;
                }
                q.addWhere(str);
            }
            ResultSet rs = q.execute();
            if (rs.next()) {
                q.close();
                upd = new SQLUpdate(db, tableName);
                for (i = 0; i < selectorColumns.length; ++i) {
                    boolean isStr = selectorValues[i] instanceof String;
                    String str = selectorColumns[i] + "=" + (isStr ? "'" : "") + selectorValues[i] + (isStr ? "'" : "");
                    if (i > 0) {
                        ((SQLUpdate)upd).addWhere("AND " + str);
                        continue;
                    }
                    ((SQLUpdate)upd).addWhere(str);
                }
                for (i = 0; i < newColumns.length; ++i) {
                    ((SQLUpdate)upd).addColumn((String)newColumns[i], newValues[i]);
                }
                ((SQLUpdate)upd).execute();
                upd.close();
            } else {
                q.close();
                ins = new SQLInsert(db, tableName);
                for (i = 0; i < selectorColumns.length; ++i) {
                    ((SQLInsert)ins).addColumn((String)selectorColumns[i], selectorValues[i]);
                }
                for (i = 0; i < newColumns.length; ++i) {
                    ((SQLInsert)ins).addColumn((String)newColumns[i], newValues[i]);
                }
                ((SQLInsert)ins).execute();
                ins.close();
            }
        }
        catch (Exception e) {
            if (q != null) {
                q.close();
            }
            if (ins != null) {
                ins.close();
            }
            if (upd != null) {
                upd.close();
            }
            ColumnDefinition.logError(1, "SQLQuery", e);
        }
    }
}

